package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatch;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.followsPattern pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class FollowsPatternProcessor implements IMatchProcessor<FollowsPatternMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEventPattern the value of pattern parameter eventPattern in the currently processed match
   * 
   */
  public abstract void process(final ComplexEventPattern pEventPattern);
  
  @Override
  public void process(final FollowsPatternMatch match) {
    process(match.getEventPattern());
  }
}
