package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexPatternQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate FollowsPatternMatcher in a type-safe way.
 * 
 * @see FollowsPatternMatcher
 * @see FollowsPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class FollowsPatternQuerySpecification extends BaseGeneratedEMFQuerySpecification<FollowsPatternMatcher> {
  private FollowsPatternQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static FollowsPatternQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected FollowsPatternMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return FollowsPatternMatcher.on(engine);
  }
  
  @Override
  public FollowsPatternMatch newEmptyMatch() {
    return FollowsPatternMatch.newEmptyMatch();
  }
  
  @Override
  public FollowsPatternMatch newMatch(final Object... parameters) {
    return FollowsPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static FollowsPatternQuerySpecification INSTANCE = make();
    
    public static FollowsPatternQuerySpecification make() {
      return new FollowsPatternQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static FollowsPatternQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.followsPattern";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventPattern, "eventPattern")
      		));
      		// 	find complexPattern(eventPattern, operator)
      		new PositivePatternCall(body, new FlatTuple(var_eventPattern, var_operator), ComplexPatternQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	FOLLOWS(operator)
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "FOLLOWS")));
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
