package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.negativeTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NegativeTransitionProcessor implements IMatchProcessor<NegativeTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * 
   */
  public abstract void process(final TypedTransition pTransition);
  
  @Override
  public void process(final NegativeTransitionMatch match) {
    process(match.getTransition());
  }
}
