package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatcher;

/**
 * A pattern-specific query specification that can instantiate NegativeTransitionMatcher in a type-safe way.
 * 
 * @see NegativeTransitionMatcher
 * @see NegativeTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class NegativeTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<NegativeTransitionMatcher> {
  private NegativeTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NegativeTransitionQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NegativeTransitionMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NegativeTransitionMatcher.on(engine);
  }
  
  @Override
  public NegativeTransitionMatch newEmptyMatch() {
    return NegativeTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public NegativeTransitionMatch newMatch(final Object... parameters) {
    return NegativeTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static NegativeTransitionQuerySpecification INSTANCE = make();
    
    public static NegativeTransitionQuerySpecification make() {
      return new NegativeTransitionQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NegativeTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.negativeTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition, "transition")
      		));
      		// 	NegativeTransition(transition)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "NegativeTransition")));
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
