package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.nonUnfoldedNotTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NonUnfoldedNotTransitionProcessor implements IMatchProcessor<NonUnfoldedNotTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pEventPattern the value of pattern parameter eventPattern in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern);
  
  @Override
  public void process(final NonUnfoldedNotTransitionMatch match) {
    process(match.getAutomaton(), match.getTransition(), match.getEventPattern());
  }
}
