package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate NonUnfoldedNotTransitionMatcher in a type-safe way.
 * 
 * @see NonUnfoldedNotTransitionMatcher
 * @see NonUnfoldedNotTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class NonUnfoldedNotTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<NonUnfoldedNotTransitionMatcher> {
  private NonUnfoldedNotTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NonUnfoldedNotTransitionQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NonUnfoldedNotTransitionMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NonUnfoldedNotTransitionMatcher.on(engine);
  }
  
  @Override
  public NonUnfoldedNotTransitionMatch newEmptyMatch() {
    return NonUnfoldedNotTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public NonUnfoldedNotTransitionMatch newMatch(final Object... parameters) {
    return NonUnfoldedNotTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) parameters[2]);
  }
  
  private static class LazyHolder {
    private final static NonUnfoldedNotTransitionQuerySpecification INSTANCE = make();
    
    public static NonUnfoldedNotTransitionQuerySpecification make() {
      return new NonUnfoldedNotTransitionQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NonUnfoldedNotTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.nonUnfoldedNotTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton"),new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"),new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, "automaton"),
      		   new ExportedParameter(body, var_transition, "transition"),
      		   new ExportedParameter(body, var_eventPattern, "eventPattern")
      		));
      		// 	find complexTransition(automaton, transition, eventPattern, operator)
      		new PositivePatternCall(body, new FlatTuple(var_automaton, var_transition, var_eventPattern, var_operator), ComplexTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	neg find negativeTransition(transition)
      		new NegativePatternCall(body, new FlatTuple(var_transition), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	NEG(operator)
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "NEG")));
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
