package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexPatternQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate NotPatternMatcher in a type-safe way.
 * 
 * @see NotPatternMatcher
 * @see NotPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class NotPatternQuerySpecification extends BaseGeneratedEMFQuerySpecification<NotPatternMatcher> {
  private NotPatternQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NotPatternQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NotPatternMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NotPatternMatcher.on(engine);
  }
  
  @Override
  public NotPatternMatch newEmptyMatch() {
    return NotPatternMatch.newEmptyMatch();
  }
  
  @Override
  public NotPatternMatch newMatch(final Object... parameters) {
    return NotPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static NotPatternQuerySpecification INSTANCE = make();
    
    public static NotPatternQuerySpecification make() {
      return new NotPatternQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NotPatternQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.notPattern";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventPattern, "eventPattern")
      		));
      		// 	find complexPattern(eventPattern, operator)
      		new PositivePatternCall(body, new FlatTuple(var_eventPattern, var_operator), ComplexPatternQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	NEG(operator)
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "NEG")));
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
