package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class SameBooleanTransitionTypeProcessor implements IMatchProcessor<SameBooleanTransitionTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition1 the value of pattern parameter transition1 in the currently processed match
   * @param pTransition2 the value of pattern parameter transition2 in the currently processed match
   * 
   */
  public abstract void process(final TypedTransition pTransition1, final TypedTransition pTransition2);
  
  @Override
  public void process(final SameBooleanTransitionTypeMatch match) {
    process(match.getTransition1(), match.getTransition2());
  }
}
