package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatch;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate SameBooleanTransitionTypeMatcher in a type-safe way.
 * 
 * @see SameBooleanTransitionTypeMatcher
 * @see SameBooleanTransitionTypeMatch
 * 
 */
@SuppressWarnings("all")
public final class SameBooleanTransitionTypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<SameBooleanTransitionTypeMatcher> {
  private SameBooleanTransitionTypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static SameBooleanTransitionTypeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected SameBooleanTransitionTypeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return SameBooleanTransitionTypeMatcher.on(engine);
  }
  
  @Override
  public SameBooleanTransitionTypeMatch newEmptyMatch() {
    return SameBooleanTransitionTypeMatch.newEmptyMatch();
  }
  
  @Override
  public SameBooleanTransitionTypeMatch newMatch(final Object... parameters) {
    return SameBooleanTransitionTypeMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static SameBooleanTransitionTypeQuerySpecification INSTANCE = make();
    
    public static SameBooleanTransitionTypeQuerySpecification make() {
      return new SameBooleanTransitionTypeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static SameBooleanTransitionTypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition1","transition2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("transition1", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"),new PParameter("transition2", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, "transition1"),
      		   new ExportedParameter(body, var_transition2, "transition2")
      		));
      		// 	find negativeTransition(transition1)
      		new PositivePatternCall(body, new FlatTuple(var_transition1), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	find negativeTransition(transition2)
      		new PositivePatternCall(body, new FlatTuple(var_transition2), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, "transition1"),
      		   new ExportedParameter(body, var_transition2, "transition2")
      		));
      		// 	neg find negativeTransition(transition1)
      		new NegativePatternCall(body, new FlatTuple(var_transition1), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	neg find negativeTransition(transition2)
      		new NegativePatternCall(body, new FlatTuple(var_transition2), NegativeTransitionQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
