package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatch;
import org.eclipse.viatra.cep.core.metamodels.events.EventPattern;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.translatedEventPattern pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TranslatedEventPatternProcessor implements IMatchProcessor<TranslatedEventPatternMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEventPattern the value of pattern parameter eventPattern in the currently processed match
   * 
   */
  public abstract void process(final EventPattern pEventPattern);
  
  @Override
  public void process(final TranslatedEventPatternMatch match) {
    process(match.getEventPattern());
  }
}
