package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatcher;

/**
 * A pattern-specific query specification that can instantiate TranslatedEventPatternMatcher in a type-safe way.
 * 
 * @see TranslatedEventPatternMatcher
 * @see TranslatedEventPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class TranslatedEventPatternQuerySpecification extends BaseGeneratedEMFQuerySpecification<TranslatedEventPatternMatcher> {
  private TranslatedEventPatternQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TranslatedEventPatternQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TranslatedEventPatternMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TranslatedEventPatternMatcher.on(engine);
  }
  
  @Override
  public TranslatedEventPatternMatch newEmptyMatch() {
    return TranslatedEventPatternMatch.newEmptyMatch();
  }
  
  @Override
  public TranslatedEventPatternMatch newMatch(final Object... parameters) {
    return TranslatedEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.EventPattern) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static TranslatedEventPatternQuerySpecification INSTANCE = make();
    
    public static TranslatedEventPatternQuerySpecification make() {
      return new TranslatedEventPatternQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TranslatedEventPatternQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.translatedEventPattern";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.EventPattern"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "EventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventPattern, "eventPattern")
      		));
      		// 	TraceModel.traces(_, trace)
      		new TypeConstraint(body, new FlatTuple(var___0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("trace.meta", "TraceModel")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var___0_, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("trace.meta", "TraceModel", "traces")));
      		new Equality(body, var__virtual_0_, var_trace);
      		// 	Trace.eventPattern(trace, eventPattern)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("trace.meta", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("trace.meta", "Trace", "eventPattern")));
      		new Equality(body, var__virtual_1_, var_eventPattern);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
