package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.viatra.cep.core.engine.runtime.PartiallyMatchedEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.PartiallyMatchedEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.partiallyMatchedEventPattern pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link PartiallyMatchedEventPatternMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern partiallyMatchedEventPattern(automaton : Automaton, eventToken : EventToken, state : State) {
 * 	Automaton.eventTokens(automaton, eventToken);
 * 	State.eventTokens(state, eventToken);
 * 	neg find initState(automaton, state);
 * }
 * </pre></code>
 * 
 * @see PartiallyMatchedEventPatternMatch
 * @see PartiallyMatchedEventPatternProcessor
 * @see PartiallyMatchedEventPatternQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class PartiallyMatchedEventPatternMatcher extends BaseMatcher<PartiallyMatchedEventPatternMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static PartiallyMatchedEventPatternMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    PartiallyMatchedEventPatternMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new PartiallyMatchedEventPatternMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_AUTOMATON = 0;
  
  private final static int POSITION_EVENTTOKEN = 1;
  
  private final static int POSITION_STATE = 2;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(PartiallyMatchedEventPatternMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public PartiallyMatchedEventPatternMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public PartiallyMatchedEventPatternMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return matches represented as a PartiallyMatchedEventPatternMatch object.
   * 
   */
  public Collection<PartiallyMatchedEventPatternMatch> getAllMatches(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return rawGetAllMatches(new Object[]{pAutomaton, pEventToken, pState});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return a match represented as a PartiallyMatchedEventPatternMatch object, or null if no match is found.
   * 
   */
  public PartiallyMatchedEventPatternMatch getOneArbitraryMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return rawGetOneArbitraryMatch(new Object[]{pAutomaton, pEventToken, pState});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return rawHasMatch(new Object[]{pAutomaton, pEventToken, pState});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return rawCountMatches(new Object[]{pAutomaton, pEventToken, pState});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState, final IMatchProcessor<? super PartiallyMatchedEventPatternMatch> processor) {
    rawForEachMatch(new Object[]{pAutomaton, pEventToken, pState}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState, final IMatchProcessor<? super PartiallyMatchedEventPatternMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pAutomaton, pEventToken, pState}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public PartiallyMatchedEventPatternMatch newMatch(final Automaton pAutomaton, final EventToken pEventToken, final State pState) {
    return PartiallyMatchedEventPatternMatch.newMatch(pAutomaton, pEventToken, pState);
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final PartiallyMatchedEventPatternMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final EventToken pEventToken, final State pState) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    null, 
    pEventToken, 
    pState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final PartiallyMatchedEventPatternMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final Automaton pAutomaton, final State pState) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    pAutomaton, 
    null, 
    pState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfstate(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_STATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate() {
    return rawAccumulateAllValuesOfstate(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final PartiallyMatchedEventPatternMatch partialMatch) {
    return rawAccumulateAllValuesOfstate(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final Automaton pAutomaton, final EventToken pEventToken) {
    return rawAccumulateAllValuesOfstate(new Object[]{
    pAutomaton, 
    pEventToken, 
    null
    });
  }
  
  @Override
  protected PartiallyMatchedEventPatternMatch tupleToMatch(final Tuple t) {
    try {
    	return PartiallyMatchedEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) t.get(POSITION_AUTOMATON), (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) t.get(POSITION_EVENTTOKEN), (org.eclipse.viatra.cep.core.metamodels.automaton.State) t.get(POSITION_STATE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected PartiallyMatchedEventPatternMatch arrayToMatch(final Object[] match) {
    try {
    	return PartiallyMatchedEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) match[POSITION_EVENTTOKEN], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_STATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected PartiallyMatchedEventPatternMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return PartiallyMatchedEventPatternMatch.newMutableMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) match[POSITION_EVENTTOKEN], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_STATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<PartiallyMatchedEventPatternMatcher> querySpecification() throws IncQueryException {
    return PartiallyMatchedEventPatternQuerySpecification.instance();
  }
}
