package org.eclipse.viatra.cep.core.engine.runtime;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledNegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.FinishedAutomatonMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.InitStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.LatestEventMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.NegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.PartiallyMatchedEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInFinalStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInInitStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInTrapStateMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledNegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.EnabledTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.EventProcessedByEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.FinishedAutomatonQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.InitStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.LatestEventQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.PartiallyMatchedEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.ResettableEventTokenQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenEntersTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInFinalStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInInitStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTrapStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenLeavesTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TransitionWithEventTypeQuerySpecification;

/**
 * A pattern group formed of all patterns defined in runtimePatterns.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file runtimePatterns.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.runtime, the group contains the definition of the following patterns: <ul>
 * <li>latestEvent</li>
 * <li>finishedAutomaton</li>
 * <li>tokenInTrapState</li>
 * <li>tokenInInitState</li>
 * <li>tokenInFinalState</li>
 * <li>resettableEventToken</li>
 * <li>enabledTransition</li>
 * <li>enabledNegativeTransition</li>
 * <li>transitionWithEventType</li>
 * <li>negativeTransition</li>
 * <li>eventProcessedByEventToken</li>
 * <li>partiallyMatchedEventPattern</li>
 * <li>initState</li>
 * <li>tokenEntersTimedZone</li>
 * <li>tokenLeavesTimedZone</li>
 * <li>tokenInTimedZone</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class RuntimePatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static RuntimePatterns instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new RuntimePatterns();
    }
    return INSTANCE;
  }
  
  private static RuntimePatterns INSTANCE;
  
  private RuntimePatterns() throws IncQueryException {
    querySpecifications.add(LatestEventQuerySpecification.instance());
    querySpecifications.add(FinishedAutomatonQuerySpecification.instance());
    querySpecifications.add(TokenInTrapStateQuerySpecification.instance());
    querySpecifications.add(TokenInInitStateQuerySpecification.instance());
    querySpecifications.add(TokenInFinalStateQuerySpecification.instance());
    querySpecifications.add(ResettableEventTokenQuerySpecification.instance());
    querySpecifications.add(EnabledTransitionQuerySpecification.instance());
    querySpecifications.add(EnabledNegativeTransitionQuerySpecification.instance());
    querySpecifications.add(TransitionWithEventTypeQuerySpecification.instance());
    querySpecifications.add(NegativeTransitionQuerySpecification.instance());
    querySpecifications.add(EventProcessedByEventTokenQuerySpecification.instance());
    querySpecifications.add(PartiallyMatchedEventPatternQuerySpecification.instance());
    querySpecifications.add(InitStateQuerySpecification.instance());
    querySpecifications.add(TokenEntersTimedZoneQuerySpecification.instance());
    querySpecifications.add(TokenLeavesTimedZoneQuerySpecification.instance());
    querySpecifications.add(TokenInTimedZoneQuerySpecification.instance());
  }
  
  public LatestEventQuerySpecification getLatestEvent() throws IncQueryException {
    return LatestEventQuerySpecification.instance();
  }
  
  public LatestEventMatcher getLatestEvent(final IncQueryEngine engine) throws IncQueryException {
    return LatestEventMatcher.on(engine);
  }
  
  public FinishedAutomatonQuerySpecification getFinishedAutomaton() throws IncQueryException {
    return FinishedAutomatonQuerySpecification.instance();
  }
  
  public FinishedAutomatonMatcher getFinishedAutomaton(final IncQueryEngine engine) throws IncQueryException {
    return FinishedAutomatonMatcher.on(engine);
  }
  
  public TokenInTrapStateQuerySpecification getTokenInTrapState() throws IncQueryException {
    return TokenInTrapStateQuerySpecification.instance();
  }
  
  public TokenInTrapStateMatcher getTokenInTrapState(final IncQueryEngine engine) throws IncQueryException {
    return TokenInTrapStateMatcher.on(engine);
  }
  
  public TokenInInitStateQuerySpecification getTokenInInitState() throws IncQueryException {
    return TokenInInitStateQuerySpecification.instance();
  }
  
  public TokenInInitStateMatcher getTokenInInitState(final IncQueryEngine engine) throws IncQueryException {
    return TokenInInitStateMatcher.on(engine);
  }
  
  public TokenInFinalStateQuerySpecification getTokenInFinalState() throws IncQueryException {
    return TokenInFinalStateQuerySpecification.instance();
  }
  
  public TokenInFinalStateMatcher getTokenInFinalState(final IncQueryEngine engine) throws IncQueryException {
    return TokenInFinalStateMatcher.on(engine);
  }
  
  public ResettableEventTokenQuerySpecification getResettableEventToken() throws IncQueryException {
    return ResettableEventTokenQuerySpecification.instance();
  }
  
  public ResettableEventTokenMatcher getResettableEventToken(final IncQueryEngine engine) throws IncQueryException {
    return ResettableEventTokenMatcher.on(engine);
  }
  
  public EnabledTransitionQuerySpecification getEnabledTransition() throws IncQueryException {
    return EnabledTransitionQuerySpecification.instance();
  }
  
  public EnabledTransitionMatcher getEnabledTransition(final IncQueryEngine engine) throws IncQueryException {
    return EnabledTransitionMatcher.on(engine);
  }
  
  public EnabledNegativeTransitionQuerySpecification getEnabledNegativeTransition() throws IncQueryException {
    return EnabledNegativeTransitionQuerySpecification.instance();
  }
  
  public EnabledNegativeTransitionMatcher getEnabledNegativeTransition(final IncQueryEngine engine) throws IncQueryException {
    return EnabledNegativeTransitionMatcher.on(engine);
  }
  
  public TransitionWithEventTypeQuerySpecification getTransitionWithEventType() throws IncQueryException {
    return TransitionWithEventTypeQuerySpecification.instance();
  }
  
  public TransitionWithEventTypeMatcher getTransitionWithEventType(final IncQueryEngine engine) throws IncQueryException {
    return TransitionWithEventTypeMatcher.on(engine);
  }
  
  public NegativeTransitionQuerySpecification getNegativeTransition() throws IncQueryException {
    return NegativeTransitionQuerySpecification.instance();
  }
  
  public NegativeTransitionMatcher getNegativeTransition(final IncQueryEngine engine) throws IncQueryException {
    return NegativeTransitionMatcher.on(engine);
  }
  
  public EventProcessedByEventTokenQuerySpecification getEventProcessedByEventToken() throws IncQueryException {
    return EventProcessedByEventTokenQuerySpecification.instance();
  }
  
  public EventProcessedByEventTokenMatcher getEventProcessedByEventToken(final IncQueryEngine engine) throws IncQueryException {
    return EventProcessedByEventTokenMatcher.on(engine);
  }
  
  public PartiallyMatchedEventPatternQuerySpecification getPartiallyMatchedEventPattern() throws IncQueryException {
    return PartiallyMatchedEventPatternQuerySpecification.instance();
  }
  
  public PartiallyMatchedEventPatternMatcher getPartiallyMatchedEventPattern(final IncQueryEngine engine) throws IncQueryException {
    return PartiallyMatchedEventPatternMatcher.on(engine);
  }
  
  public InitStateQuerySpecification getInitState() throws IncQueryException {
    return InitStateQuerySpecification.instance();
  }
  
  public InitStateMatcher getInitState(final IncQueryEngine engine) throws IncQueryException {
    return InitStateMatcher.on(engine);
  }
  
  public TokenEntersTimedZoneQuerySpecification getTokenEntersTimedZone() throws IncQueryException {
    return TokenEntersTimedZoneQuerySpecification.instance();
  }
  
  public TokenEntersTimedZoneMatcher getTokenEntersTimedZone(final IncQueryEngine engine) throws IncQueryException {
    return TokenEntersTimedZoneMatcher.on(engine);
  }
  
  public TokenLeavesTimedZoneQuerySpecification getTokenLeavesTimedZone() throws IncQueryException {
    return TokenLeavesTimedZoneQuerySpecification.instance();
  }
  
  public TokenLeavesTimedZoneMatcher getTokenLeavesTimedZone(final IncQueryEngine engine) throws IncQueryException {
    return TokenLeavesTimedZoneMatcher.on(engine);
  }
  
  public TokenInTimedZoneQuerySpecification getTokenInTimedZone() throws IncQueryException {
    return TokenInTimedZoneQuerySpecification.instance();
  }
  
  public TokenInTimedZoneMatcher getTokenInTimedZone(final IncQueryEngine engine) throws IncQueryException {
    return TokenInTimedZoneMatcher.on(engine);
  }
}
