package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatch;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenEntersTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.runtime.tokenEntersTimedZone pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link TokenEntersTimedZoneMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * ////////////TIMING PATTERNS////////////
 * 
 * pattern tokenEntersTimedZone(eventToken : EventToken, state : State, timedZone : TimedZone) {
 * 	EventToken.currentState(eventToken, state);
 * 	State.inStateOf(state, timedZone);
 * }
 * </pre></code>
 * 
 * @see TokenEntersTimedZoneMatch
 * @see TokenEntersTimedZoneProcessor
 * @see TokenEntersTimedZoneQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class TokenEntersTimedZoneMatcher extends BaseMatcher<TokenEntersTimedZoneMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TokenEntersTimedZoneMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    TokenEntersTimedZoneMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new TokenEntersTimedZoneMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_EVENTTOKEN = 0;
  
  private final static int POSITION_STATE = 1;
  
  private final static int POSITION_TIMEDZONE = 2;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(TokenEntersTimedZoneMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public TokenEntersTimedZoneMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public TokenEntersTimedZoneMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return matches represented as a TokenEntersTimedZoneMatch object.
   * 
   */
  public Collection<TokenEntersTimedZoneMatch> getAllMatches(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawGetAllMatches(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return a match represented as a TokenEntersTimedZoneMatch object, or null if no match is found.
   * 
   */
  public TokenEntersTimedZoneMatch getOneArbitraryMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawGetOneArbitraryMatch(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawHasMatch(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return rawCountMatches(new Object[]{pEventToken, pState, pTimedZone});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final IMatchProcessor<? super TokenEntersTimedZoneMatch> processor) {
    rawForEachMatch(new Object[]{pEventToken, pState, pTimedZone}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final IMatchProcessor<? super TokenEntersTimedZoneMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEventToken, pState, pTimedZone}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public TokenEntersTimedZoneMatch newMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone) {
    return TokenEntersTimedZoneMatch.newMatch(pEventToken, pState, pTimedZone);
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventToken> rawAccumulateAllValuesOfeventToken(final Object[] parameters) {
    Set<EventToken> results = new HashSet<EventToken>();
    rawAccumulateAllValues(POSITION_EVENTTOKEN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken() {
    return rawAccumulateAllValuesOfeventToken(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOfeventToken(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventToken.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventToken> getAllValuesOfeventToken(final State pState, final TimedZone pTimedZone) {
    return rawAccumulateAllValuesOfeventToken(new Object[]{
    null, 
    pState, 
    pTimedZone
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfstate(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_STATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate() {
    return rawAccumulateAllValuesOfstate(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOfstate(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for state.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfstate(final EventToken pEventToken, final TimedZone pTimedZone) {
    return rawAccumulateAllValuesOfstate(new Object[]{
    pEventToken, 
    null, 
    pTimedZone
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TimedZone> rawAccumulateAllValuesOftimedZone(final Object[] parameters) {
    Set<TimedZone> results = new HashSet<TimedZone>();
    rawAccumulateAllValues(POSITION_TIMEDZONE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone() {
    return rawAccumulateAllValuesOftimedZone(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone(final TokenEntersTimedZoneMatch partialMatch) {
    return rawAccumulateAllValuesOftimedZone(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for timedZone.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TimedZone> getAllValuesOftimedZone(final EventToken pEventToken, final State pState) {
    return rawAccumulateAllValuesOftimedZone(new Object[]{
    pEventToken, 
    pState, 
    null
    });
  }
  
  @Override
  protected TokenEntersTimedZoneMatch tupleToMatch(final Tuple t) {
    try {
    	return TokenEntersTimedZoneMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) t.get(POSITION_EVENTTOKEN), (org.eclipse.viatra.cep.core.metamodels.automaton.State) t.get(POSITION_STATE), (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) t.get(POSITION_TIMEDZONE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenEntersTimedZoneMatch arrayToMatch(final Object[] match) {
    try {
    	return TokenEntersTimedZoneMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) match[POSITION_EVENTTOKEN], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_STATE], (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) match[POSITION_TIMEDZONE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TokenEntersTimedZoneMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return TokenEntersTimedZoneMatch.newMutableMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) match[POSITION_EVENTTOKEN], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_STATE], (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) match[POSITION_TIMEDZONE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<TokenEntersTimedZoneMatcher> querySpecification() throws IncQueryException {
    return TokenEntersTimedZoneQuerySpecification.instance();
  }
}
