package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInTrapStateQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.tokenInTrapState pattern,
 * to be used in conjunction with {@link TokenInTrapStateMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see TokenInTrapStateMatcher
 * @see TokenInTrapStateProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class TokenInTrapStateMatch extends BasePatternMatch {
  private Automaton fAutomaton;
  
  private EventToken fEventToken;
  
  private static List<String> parameterNames = makeImmutableList("automaton", "eventToken");
  
  private TokenInTrapStateMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    this.fAutomaton = pAutomaton;
    this.fEventToken = pEventToken;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("automaton".equals(parameterName)) return this.fAutomaton;
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    return null;
  }
  
  public Automaton getAutomaton() {
    return this.fAutomaton;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("automaton".equals(parameterName) ) {
    	this.fAutomaton = (org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) newValue;
    	return true;
    }
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) newValue;
    	return true;
    }
    return false;
  }
  
  public void setAutomaton(final Automaton pAutomaton) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fAutomaton = pAutomaton;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.tokenInTrapState";
  }
  
  @Override
  public List<String> parameterNames() {
    return TokenInTrapStateMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fAutomaton, fEventToken};
  }
  
  @Override
  public TokenInTrapStateMatch toImmutable() {
    return isMutable() ? newMatch(fAutomaton, fEventToken) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"automaton\"=" + prettyPrintValue(fAutomaton) + ", ");
    
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fAutomaton == null) ? 0 : fAutomaton.hashCode());
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof TokenInTrapStateMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    TokenInTrapStateMatch other = (TokenInTrapStateMatch) obj;
    if (fAutomaton == null) {if (other.fAutomaton != null) return false;}
    else if (!fAutomaton.equals(other.fAutomaton)) return false;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    return true;
  }
  
  @Override
  public TokenInTrapStateQuerySpecification specification() {
    try {
    	return TokenInTrapStateQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static TokenInTrapStateMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static TokenInTrapStateMatch newMutableMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    return new Mutable(pAutomaton, pEventToken);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static TokenInTrapStateMatch newMatch(final Automaton pAutomaton, final EventToken pEventToken) {
    return new Immutable(pAutomaton, pEventToken);
  }
  
  private static final class Mutable extends TokenInTrapStateMatch {
    Mutable(final Automaton pAutomaton, final EventToken pEventToken) {
      super(pAutomaton, pEventToken);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends TokenInTrapStateMatch {
    Immutable(final Automaton pAutomaton, final EventToken pEventToken) {
      super(pAutomaton, pEventToken);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
