package org.eclipse.viatra.cep.core.engine.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenLeavesTimedZoneQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.cep.core.metamodels.automaton.TrapState;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.runtime.tokenLeavesTimedZone pattern,
 * to be used in conjunction with {@link TokenLeavesTimedZoneMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see TokenLeavesTimedZoneMatcher
 * @see TokenLeavesTimedZoneProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class TokenLeavesTimedZoneMatch extends BasePatternMatch {
  private EventToken fEventToken;
  
  private State fState;
  
  private TimedZone fTimedZone;
  
  private TrapState fTrapState;
  
  private static List<String> parameterNames = makeImmutableList("eventToken", "state", "timedZone", "trapState");
  
  private TokenLeavesTimedZoneMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState) {
    this.fEventToken = pEventToken;
    this.fState = pState;
    this.fTimedZone = pTimedZone;
    this.fTrapState = pTrapState;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("eventToken".equals(parameterName)) return this.fEventToken;
    if ("state".equals(parameterName)) return this.fState;
    if ("timedZone".equals(parameterName)) return this.fTimedZone;
    if ("trapState".equals(parameterName)) return this.fTrapState;
    return null;
  }
  
  public EventToken getEventToken() {
    return this.fEventToken;
  }
  
  public State getState() {
    return this.fState;
  }
  
  public TimedZone getTimedZone() {
    return this.fTimedZone;
  }
  
  public TrapState getTrapState() {
    return this.fTrapState;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("eventToken".equals(parameterName) ) {
    	this.fEventToken = (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) newValue;
    	return true;
    }
    if ("state".equals(parameterName) ) {
    	this.fState = (org.eclipse.viatra.cep.core.metamodels.automaton.State) newValue;
    	return true;
    }
    if ("timedZone".equals(parameterName) ) {
    	this.fTimedZone = (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) newValue;
    	return true;
    }
    if ("trapState".equals(parameterName) ) {
    	this.fTrapState = (org.eclipse.viatra.cep.core.metamodels.automaton.TrapState) newValue;
    	return true;
    }
    return false;
  }
  
  public void setEventToken(final EventToken pEventToken) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventToken = pEventToken;
  }
  
  public void setState(final State pState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fState = pState;
  }
  
  public void setTimedZone(final TimedZone pTimedZone) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTimedZone = pTimedZone;
  }
  
  public void setTrapState(final TrapState pTrapState) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTrapState = pTrapState;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.runtime.tokenLeavesTimedZone";
  }
  
  @Override
  public List<String> parameterNames() {
    return TokenLeavesTimedZoneMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fEventToken, fState, fTimedZone, fTrapState};
  }
  
  @Override
  public TokenLeavesTimedZoneMatch toImmutable() {
    return isMutable() ? newMatch(fEventToken, fState, fTimedZone, fTrapState) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"eventToken\"=" + prettyPrintValue(fEventToken) + ", ");
    
    result.append("\"state\"=" + prettyPrintValue(fState) + ", ");
    
    result.append("\"timedZone\"=" + prettyPrintValue(fTimedZone) + ", ");
    
    result.append("\"trapState\"=" + prettyPrintValue(fTrapState)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fEventToken == null) ? 0 : fEventToken.hashCode());
    result = prime * result + ((fState == null) ? 0 : fState.hashCode());
    result = prime * result + ((fTimedZone == null) ? 0 : fTimedZone.hashCode());
    result = prime * result + ((fTrapState == null) ? 0 : fTrapState.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof TokenLeavesTimedZoneMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    TokenLeavesTimedZoneMatch other = (TokenLeavesTimedZoneMatch) obj;
    if (fEventToken == null) {if (other.fEventToken != null) return false;}
    else if (!fEventToken.equals(other.fEventToken)) return false;
    if (fState == null) {if (other.fState != null) return false;}
    else if (!fState.equals(other.fState)) return false;
    if (fTimedZone == null) {if (other.fTimedZone != null) return false;}
    else if (!fTimedZone.equals(other.fTimedZone)) return false;
    if (fTrapState == null) {if (other.fTrapState != null) return false;}
    else if (!fTrapState.equals(other.fTrapState)) return false;
    return true;
  }
  
  @Override
  public TokenLeavesTimedZoneQuerySpecification specification() {
    try {
    	return TokenLeavesTimedZoneQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static TokenLeavesTimedZoneMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param pTrapState the fixed value of pattern parameter trapState, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static TokenLeavesTimedZoneMatch newMutableMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState) {
    return new Mutable(pEventToken, pState, pTimedZone, pTrapState);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventToken the fixed value of pattern parameter eventToken, or null if not bound.
   * @param pState the fixed value of pattern parameter state, or null if not bound.
   * @param pTimedZone the fixed value of pattern parameter timedZone, or null if not bound.
   * @param pTrapState the fixed value of pattern parameter trapState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static TokenLeavesTimedZoneMatch newMatch(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState) {
    return new Immutable(pEventToken, pState, pTimedZone, pTrapState);
  }
  
  private static final class Mutable extends TokenLeavesTimedZoneMatch {
    Mutable(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState) {
      super(pEventToken, pState, pTimedZone, pTrapState);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends TokenLeavesTimedZoneMatch {
    Immutable(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState) {
      super(pEventToken, pState, pTimedZone, pTrapState);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
