package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.EnabledNegativeTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.NegativeTransition;
import org.eclipse.viatra.cep.core.metamodels.events.Event;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.enabledNegativeTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EnabledNegativeTransitionProcessor implements IMatchProcessor<EnabledNegativeTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * @param pEvent the value of pattern parameter event in the currently processed match
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * 
   */
  public abstract void process(final NegativeTransition pTransition, final EventToken pEventToken, final Event pEvent, final Automaton pAutomaton);
  
  @Override
  public void process(final EnabledNegativeTransitionMatch match) {
    process(match.getTransition(), match.getEventToken(), match.getEvent(), match.getAutomaton());
  }
}
