package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.events.Event;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.eventProcessedByEventToken pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EventProcessedByEventTokenProcessor implements IMatchProcessor<EventProcessedByEventTokenMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEvent the value of pattern parameter event in the currently processed match
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * 
   */
  public abstract void process(final Event pEvent, final EventToken pEventToken);
  
  @Override
  public void process(final EventProcessedByEventTokenMatch match) {
    process(match.getEvent(), match.getEventToken());
  }
}
