package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatch;
import org.eclipse.viatra.cep.core.engine.runtime.EventProcessedByEventTokenMatcher;

/**
 * A pattern-specific query specification that can instantiate EventProcessedByEventTokenMatcher in a type-safe way.
 * 
 * @see EventProcessedByEventTokenMatcher
 * @see EventProcessedByEventTokenMatch
 * 
 */
@SuppressWarnings("all")
public final class EventProcessedByEventTokenQuerySpecification extends BaseGeneratedEMFQuerySpecification<EventProcessedByEventTokenMatcher> {
  private EventProcessedByEventTokenQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static EventProcessedByEventTokenQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EventProcessedByEventTokenMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return EventProcessedByEventTokenMatcher.on(engine);
  }
  
  @Override
  public EventProcessedByEventTokenMatch newEmptyMatch() {
    return EventProcessedByEventTokenMatch.newEmptyMatch();
  }
  
  @Override
  public EventProcessedByEventTokenMatch newMatch(final Object... parameters) {
    return EventProcessedByEventTokenMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.Event) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static EventProcessedByEventTokenQuerySpecification INSTANCE = make();
    
    public static EventProcessedByEventTokenQuerySpecification make() {
      return new EventProcessedByEventTokenQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EventProcessedByEventTokenQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.eventProcessedByEventToken";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("event","eventToken");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("event", "org.eclipse.viatra.cep.core.metamodels.events.Event"),new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_event = body.getOrCreateVariableByName("event");
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		new TypeConstraint(body, new FlatTuple(var_event), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "Event")));
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_event, "event"),
      		   new ExportedParameter(body, var_eventToken, "eventToken")
      		));
      		// 	EventToken.lastProcessed(eventToken, event)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "lastProcessed")));
      		new Equality(body, var__virtual_0_, var_event);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
