package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.FinishedAutomatonMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.finishedAutomaton pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class FinishedAutomatonProcessor implements IMatchProcessor<FinishedAutomatonMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final EventToken pEventToken);
  
  @Override
  public void process(final FinishedAutomatonMatch match) {
    process(match.getAutomaton(), match.getEventToken());
  }
}
