package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.LatestEventMatch;
import org.eclipse.viatra.cep.core.metamodels.events.Event;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.latestEvent pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class LatestEventProcessor implements IMatchProcessor<LatestEventMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEvent the value of pattern parameter event in the currently processed match
   * 
   */
  public abstract void process(final Event pEvent);
  
  @Override
  public void process(final LatestEventMatch match) {
    process(match.getEvent());
  }
}
