package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.LatestEventMatch;
import org.eclipse.viatra.cep.core.engine.runtime.LatestEventMatcher;

/**
 * A pattern-specific query specification that can instantiate LatestEventMatcher in a type-safe way.
 * 
 * @see LatestEventMatcher
 * @see LatestEventMatch
 * 
 */
@SuppressWarnings("all")
public final class LatestEventQuerySpecification extends BaseGeneratedEMFQuerySpecification<LatestEventMatcher> {
  private LatestEventQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static LatestEventQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected LatestEventMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return LatestEventMatcher.on(engine);
  }
  
  @Override
  public LatestEventMatch newEmptyMatch() {
    return LatestEventMatch.newEmptyMatch();
  }
  
  @Override
  public LatestEventMatch newMatch(final Object... parameters) {
    return LatestEventMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.Event) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static LatestEventQuerySpecification INSTANCE = make();
    
    public static LatestEventQuerySpecification make() {
      return new LatestEventQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static LatestEventQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.latestEvent";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("event");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("event", "org.eclipse.viatra.cep.core.metamodels.events.Event"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_event = body.getOrCreateVariableByName("event");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		new TypeConstraint(body, new FlatTuple(var_event), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "Event")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_event, "event")
      		));
      		// 	InternalModel.latestEvent(_, event)
      		new TypeConstraint(body, new FlatTuple(var___0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "InternalModel")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var___0_, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "InternalModel", "latestEvent")));
      		new Equality(body, var__virtual_0_, var_event);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
