package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.PartiallyMatchedEventPatternMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.partiallyMatchedEventPattern pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class PartiallyMatchedEventPatternProcessor implements IMatchProcessor<PartiallyMatchedEventPatternMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * @param pState the value of pattern parameter state in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final EventToken pEventToken, final State pState);
  
  @Override
  public void process(final PartiallyMatchedEventPatternMatch match) {
    process(match.getAutomaton(), match.getEventToken(), match.getState());
  }
}
