package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatch;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatcher;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInFinalStateQuerySpecification;
import org.eclipse.viatra.cep.core.engine.runtime.util.TokenInInitStateQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate ResettableEventTokenMatcher in a type-safe way.
 * 
 * @see ResettableEventTokenMatcher
 * @see ResettableEventTokenMatch
 * 
 */
@SuppressWarnings("all")
public final class ResettableEventTokenQuerySpecification extends BaseGeneratedEMFQuerySpecification<ResettableEventTokenMatcher> {
  private ResettableEventTokenQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ResettableEventTokenQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ResettableEventTokenMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ResettableEventTokenMatcher.on(engine);
  }
  
  @Override
  public ResettableEventTokenMatch newEmptyMatch() {
    return ResettableEventTokenMatch.newEmptyMatch();
  }
  
  @Override
  public ResettableEventTokenMatch newMatch(final Object... parameters) {
    return ResettableEventTokenMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ResettableEventTokenQuerySpecification INSTANCE = make();
    
    public static ResettableEventTokenQuerySpecification make() {
      return new ResettableEventTokenQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ResettableEventTokenQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.resettableEventToken";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","eventToken");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton"),new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, "automaton"),
      		   new ExportedParameter(body, var_eventToken, "eventToken")
      		));
      		// 	neg find tokenInInitState(automaton, eventToken)
      		new NegativePatternCall(body, new FlatTuple(var_automaton, var_eventToken), TokenInInitStateQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	neg find tokenInFinalState(automaton, eventToken)
      		new NegativePatternCall(body, new FlatTuple(var_automaton, var_eventToken), TokenInFinalStateQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
