package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatch;
import org.eclipse.viatra.cep.core.engine.runtime.TokenEntersTimedZoneMatcher;

/**
 * A pattern-specific query specification that can instantiate TokenEntersTimedZoneMatcher in a type-safe way.
 * 
 * @see TokenEntersTimedZoneMatcher
 * @see TokenEntersTimedZoneMatch
 * 
 */
@SuppressWarnings("all")
public final class TokenEntersTimedZoneQuerySpecification extends BaseGeneratedEMFQuerySpecification<TokenEntersTimedZoneMatcher> {
  private TokenEntersTimedZoneQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TokenEntersTimedZoneQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TokenEntersTimedZoneMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TokenEntersTimedZoneMatcher.on(engine);
  }
  
  @Override
  public TokenEntersTimedZoneMatch newEmptyMatch() {
    return TokenEntersTimedZoneMatch.newEmptyMatch();
  }
  
  @Override
  public TokenEntersTimedZoneMatch newMatch(final Object... parameters) {
    return TokenEntersTimedZoneMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) parameters[2]);
  }
  
  private static class LazyHolder {
    private final static TokenEntersTimedZoneQuerySpecification INSTANCE = make();
    
    public static TokenEntersTimedZoneQuerySpecification make() {
      return new TokenEntersTimedZoneQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TokenEntersTimedZoneQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.tokenEntersTimedZone";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventToken","state","timedZone");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken"),new PParameter("state", "org.eclipse.viatra.cep.core.metamodels.automaton.State"),new PParameter("timedZone", "org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_state = body.getOrCreateVariableByName("state");
      		PVariable var_timedZone = body.getOrCreateVariableByName("timedZone");
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_timedZone), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TimedZone")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventToken, "eventToken"),
      		   new ExportedParameter(body, var_state, "state"),
      		   new ExportedParameter(body, var_timedZone, "timedZone")
      		));
      		// 	EventToken.currentState(eventToken, state)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "currentState")));
      		new Equality(body, var__virtual_0_, var_state);
      		// 	State.inStateOf(state, timedZone)
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_state, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "inStateOf")));
      		new Equality(body, var__virtual_1_, var_timedZone);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
