package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInFinalStateMatch;
import org.eclipse.viatra.cep.core.engine.runtime.TokenInFinalStateMatcher;

/**
 * A pattern-specific query specification that can instantiate TokenInFinalStateMatcher in a type-safe way.
 * 
 * @see TokenInFinalStateMatcher
 * @see TokenInFinalStateMatch
 * 
 */
@SuppressWarnings("all")
public final class TokenInFinalStateQuerySpecification extends BaseGeneratedEMFQuerySpecification<TokenInFinalStateMatcher> {
  private TokenInFinalStateQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TokenInFinalStateQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TokenInFinalStateMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TokenInFinalStateMatcher.on(engine);
  }
  
  @Override
  public TokenInFinalStateMatch newEmptyMatch() {
    return TokenInFinalStateMatch.newEmptyMatch();
  }
  
  @Override
  public TokenInFinalStateMatch newMatch(final Object... parameters) {
    return TokenInFinalStateMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static TokenInFinalStateQuerySpecification INSTANCE = make();
    
    public static TokenInFinalStateQuerySpecification make() {
      return new TokenInFinalStateQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TokenInFinalStateQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.tokenInFinalState";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","eventToken");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton"),new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_finalState = body.getOrCreateVariableByName("finalState");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, "automaton"),
      		   new ExportedParameter(body, var_eventToken, "eventToken")
      		));
      		// 	Automaton.finalStates(automaton, finalState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "finalStates")));
      		new Equality(body, var__virtual_0_, var_finalState);
      		// 	FinalState.eventTokens(finalState, eventToken)
      		new TypeConstraint(body, new FlatTuple(var_finalState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "FinalState")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_finalState, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "eventTokens")));
      		new Equality(body, var__virtual_1_, var_eventToken);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
