package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone;
import org.eclipse.viatra.cep.core.metamodels.automaton.TrapState;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.tokenLeavesTimedZone pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TokenLeavesTimedZoneProcessor implements IMatchProcessor<TokenLeavesTimedZoneMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEventToken the value of pattern parameter eventToken in the currently processed match
   * @param pState the value of pattern parameter state in the currently processed match
   * @param pTimedZone the value of pattern parameter timedZone in the currently processed match
   * @param pTrapState the value of pattern parameter trapState in the currently processed match
   * 
   */
  public abstract void process(final EventToken pEventToken, final State pState, final TimedZone pTimedZone, final TrapState pTrapState);
  
  @Override
  public void process(final TokenLeavesTimedZoneMatch match) {
    process(match.getEventToken(), match.getState(), match.getTimedZone(), match.getTrapState());
  }
}
