package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatch;
import org.eclipse.viatra.cep.core.engine.runtime.TokenLeavesTimedZoneMatcher;

/**
 * A pattern-specific query specification that can instantiate TokenLeavesTimedZoneMatcher in a type-safe way.
 * 
 * @see TokenLeavesTimedZoneMatcher
 * @see TokenLeavesTimedZoneMatch
 * 
 */
@SuppressWarnings("all")
public final class TokenLeavesTimedZoneQuerySpecification extends BaseGeneratedEMFQuerySpecification<TokenLeavesTimedZoneMatcher> {
  private TokenLeavesTimedZoneQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TokenLeavesTimedZoneQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TokenLeavesTimedZoneMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TokenLeavesTimedZoneMatcher.on(engine);
  }
  
  @Override
  public TokenLeavesTimedZoneMatch newEmptyMatch() {
    return TokenLeavesTimedZoneMatch.newEmptyMatch();
  }
  
  @Override
  public TokenLeavesTimedZoneMatch newMatch(final Object... parameters) {
    return TokenLeavesTimedZoneMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.EventToken) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.TrapState) parameters[3]);
  }
  
  private static class LazyHolder {
    private final static TokenLeavesTimedZoneQuerySpecification INSTANCE = make();
    
    public static TokenLeavesTimedZoneQuerySpecification make() {
      return new TokenLeavesTimedZoneQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TokenLeavesTimedZoneQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.tokenLeavesTimedZone";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventToken","state","timedZone","trapState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventToken", "org.eclipse.viatra.cep.core.metamodels.automaton.EventToken"),new PParameter("state", "org.eclipse.viatra.cep.core.metamodels.automaton.State"),new PParameter("timedZone", "org.eclipse.viatra.cep.core.metamodels.automaton.TimedZone"),new PParameter("trapState", "org.eclipse.viatra.cep.core.metamodels.automaton.TrapState"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventToken = body.getOrCreateVariableByName("eventToken");
      		PVariable var_state = body.getOrCreateVariableByName("state");
      		PVariable var_timedZone = body.getOrCreateVariableByName("timedZone");
      		PVariable var_trapState = body.getOrCreateVariableByName("trapState");
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_timedZone), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TimedZone")));
      		new TypeConstraint(body, new FlatTuple(var_trapState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TrapState")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventToken, "eventToken"),
      		   new ExportedParameter(body, var_state, "state"),
      		   new ExportedParameter(body, var_timedZone, "timedZone"),
      		   new ExportedParameter(body, var_trapState, "trapState")
      		));
      		// 	EventToken.currentState(eventToken, state)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "currentState")));
      		new Equality(body, var__virtual_0_, var_state);
      		// 	EventToken.timedZones(eventToken, timedZone)
      		new TypeConstraint(body, new FlatTuple(var_eventToken), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EventToken")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_eventToken, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "EventToken", "timedZones")));
      		new Equality(body, var__virtual_1_, var_timedZone);
      		// 	State.outStateOf(state, timedZone)
      		new TypeConstraint(body, new FlatTuple(var_state), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_state, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outStateOf")));
      		new Equality(body, var__virtual_2_, var_timedZone);
      		// 		Automaton.eventTokens(automaton, eventToken)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "eventTokens")));
      		new Equality(body, var__virtual_3_, var_eventToken);
      		// 	Automaton.states(automaton, trapState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_4_, var_trapState);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
