package org.eclipse.viatra.cep.core.engine.runtime.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Transition;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TransitionWithEventTypeProcessor implements IMatchProcessor<TransitionWithEventTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pEventType the value of pattern parameter eventType in the currently processed match
   * 
   */
  public abstract void process(final Transition pTransition, final String pEventType);
  
  @Override
  public void process(final TransitionWithEventTypeMatch match) {
    process(match.getTransition(), match.getEventType());
  }
}
