package org.eclipse.viatra.cep.core.engine.runtime.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatch;
import org.eclipse.viatra.cep.core.engine.runtime.TransitionWithEventTypeMatcher;

/**
 * A pattern-specific query specification that can instantiate TransitionWithEventTypeMatcher in a type-safe way.
 * 
 * @see TransitionWithEventTypeMatcher
 * @see TransitionWithEventTypeMatch
 * 
 */
@SuppressWarnings("all")
public final class TransitionWithEventTypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<TransitionWithEventTypeMatcher> {
  private TransitionWithEventTypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TransitionWithEventTypeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TransitionWithEventTypeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TransitionWithEventTypeMatcher.on(engine);
  }
  
  @Override
  public TransitionWithEventTypeMatch newEmptyMatch() {
    return TransitionWithEventTypeMatch.newEmptyMatch();
  }
  
  @Override
  public TransitionWithEventTypeMatch newMatch(final Object... parameters) {
    return TransitionWithEventTypeMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Transition) parameters[0], (java.lang.String) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static TransitionWithEventTypeQuerySpecification INSTANCE = make();
    
    public static TransitionWithEventTypeQuerySpecification make() {
      return new TransitionWithEventTypeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TransitionWithEventTypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.runtime.transitionWithEventType";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition","eventType");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.Transition"),new PParameter("eventType", "java.lang.String"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventType = body.getOrCreateVariableByName("eventType");
      		PVariable var_eventPatternReference = body.getOrCreateVariableByName("eventPatternReference");
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		new TypeConstraint(body, new FlatTuple(var_eventType), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EString")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition, "transition"),
      		   new ExportedParameter(body, var_eventType, "eventType")
      		));
      		// 	NegativeTransition.guards.eventType(transition, eventPatternReference)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "NegativeTransition")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_transition, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var__virtual_0_, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_1_, var_eventPatternReference);
      		// 	AtomicEventPattern.type(eventPatternReference, eventType)
      		new TypeConstraint(body, new FlatTuple(var_eventPatternReference), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "AtomicEventPattern")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_eventPatternReference, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "AtomicEventPattern", "type")));
      		new Equality(body, var__virtual_2_, var_eventType);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
