/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 *   Andras Okros - minor changes
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedQuerySpecification;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Model Inferrer for Pattern grouping. Infers a Group class for every PatternModel.
 */
@SuppressWarnings("all")
public class PatternGroupClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private TypeReferences _typeReferences;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  public JvmGenericType inferPatternGroupClass(final PatternModel model) {
    String _groupClassName = this.groupClassName(model);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        String _packageName = model.getPackageName();
        it.setPackageName(_packageName);
        it.setFinal(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _newTypeRef = PatternGroupClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(model, BaseGeneratedPatternGroup.class);
        PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
      }
    };
    return this._eMFJvmTypesBuilder.toClass(model, _groupClassName, _function);
  }
  
  public JvmGenericType initializePatternGroup(final JvmGenericType groupClass, final PatternModel model) {
    JvmGenericType _xblockexpression = null;
    {
      CharSequence _javadocGroupClass = this._javadocInferrer.javadocGroupClass(model);
      String _string = _javadocGroupClass.toString();
      this._eMFJvmTypesBuilder.setDocumentation(groupClass, _string);
      EList<JvmMember> _members = groupClass.getMembers();
      JvmOperation _inferInstanceMethod = this.inferInstanceMethod(model, groupClass);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _inferInstanceMethod);
      EList<JvmMember> _members_1 = groupClass.getMembers();
      JvmField _inferInstanceField = this.inferInstanceField(model, groupClass);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _inferInstanceField);
      EList<JvmMember> _members_2 = groupClass.getMembers();
      JvmConstructor _inferConstructor = this.inferConstructor(model, groupClass);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_2, _inferConstructor);
      EList<Pattern> _patterns = model.getPatterns();
      final Function1<Pattern, Boolean> _function = new Function1<Pattern, Boolean>() {
        public Boolean apply(final Pattern it) {
          boolean _and = false;
          boolean _isPublic = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it);
          if (!_isPublic) {
            _and = false;
          } else {
            String _name = it.getName();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
            boolean _not = (!_isNullOrEmpty);
            _and = _not;
          }
          return Boolean.valueOf(_and);
        }
      };
      Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(_patterns, _function);
      for (final Pattern pattern : _filter) {
        {
          EList<JvmMember> _members_3 = groupClass.getMembers();
          JvmGenericType _findInferredClass = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(pattern, BaseGeneratedQuerySpecification.class);
          JvmOperation _inferSpecificationGetter = this.inferSpecificationGetter(pattern, groupClass, _findInferredClass);
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _inferSpecificationGetter);
          EList<JvmMember> _members_4 = groupClass.getMembers();
          JvmGenericType _findInferredClass_1 = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(pattern, BaseMatcher.class);
          JvmOperation _inferMatcherGetter = this.inferMatcherGetter(pattern, groupClass, _findInferredClass_1);
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _inferMatcherGetter);
        }
      }
      _xblockexpression = groupClass;
    }
    return _xblockexpression;
  }
  
  public String groupClassName(final PatternModel model) {
    final String fileName = this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model);
    return StringExtensions.toFirstUpper(fileName);
  }
  
  public JvmField inferInstanceField(final PatternModel model, final JvmGenericType groupClass) {
    JvmParameterizedTypeReference _createTypeRef = this._typeReferences.createTypeRef(groupClass);
    final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
      public void apply(final JvmField it) {
        it.setVisibility(JvmVisibility.PRIVATE);
        it.setStatic(true);
      }
    };
    return this._eMFJvmTypesBuilder.toField(groupClass, "INSTANCE", _createTypeRef, _function);
  }
  
  public JvmOperation inferInstanceMethod(final PatternModel model, final JvmGenericType groupClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      JvmParameterizedTypeReference _createTypeRef = this._typeReferences.createTypeRef(groupClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          CharSequence _javadocGroupClassInstanceMethod = PatternGroupClassInferrer.this._javadocInferrer.javadocGroupClassInstanceMethod(model);
          String _string = _javadocGroupClassInstanceMethod.toString();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          it.setVisibility(JvmVisibility.PUBLIC);
          it.setStatic(true);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("if (INSTANCE == null) {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("INSTANCE = new ");
              it.append(_builder);
              it.append(groupClass);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("();");
              _builder_1.newLine();
              _builder_1.append("}");
              _builder_1.newLine();
              _builder_1.append("return INSTANCE;");
              _builder_1.newLine();
              it.append(_builder_1);
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(groupClass, "instance", _createTypeRef, _function);
    }
    return _xblockexpression;
  }
  
  public JvmConstructor inferConstructor(final PatternModel model, final JvmGenericType groupClass) {
    JvmConstructor _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
        public void apply(final JvmConstructor it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          String _groupClassName = PatternGroupClassInferrer.this.groupClassName(model);
          it.setSimpleName(_groupClassName);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              EList<Pattern> _patterns = model.getPatterns();
              final Function1<Pattern, Boolean> _function = new Function1<Pattern, Boolean>() {
                public Boolean apply(final Pattern it) {
                  return Boolean.valueOf(PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it));
                }
              };
              Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(_patterns, _function);
              final Function1<Pattern, JvmParameterizedTypeReference> _function_1 = new Function1<Pattern, JvmParameterizedTypeReference>() {
                public JvmParameterizedTypeReference apply(final Pattern it) {
                  JvmGenericType _findInferredSpecification = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(it);
                  return PatternGroupClassInferrer.this._typeReferences.createTypeRef(_findInferredSpecification);
                }
              };
              Iterable<JvmParameterizedTypeReference> _map = IterableExtensions.<Pattern, JvmParameterizedTypeReference>map(_filter, _function_1);
              for (final JvmParameterizedTypeReference matcherRef : _map) {
                {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("querySpecifications.add(");
                  it.append(_builder);
                  PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, matcherRef, model);
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append(".instance());");
                  it.append(_builder_1);
                  it.newLine();
                }
              }
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toConstructor(groupClass, _function);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferSpecificationGetter(final Pattern model, final JvmGenericType groupClass, final JvmGenericType specificationClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      String _name = model.getName();
      String _firstUpper = StringExtensions.toFirstUpper(_name);
      String _plus = ("get" + _firstUpper);
      JvmParameterizedTypeReference _createTypeRef = this._typeReferences.createTypeRef(specificationClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              it.append(_builder);
              JvmParameterizedTypeReference _createTypeRef = PatternGroupClassInferrer.this._typeReferences.createTypeRef(specificationClass);
              PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, _createTypeRef, model);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(".instance();");
              it.append(_builder_1);
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, _createTypeRef, _function);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferMatcherGetter(final Pattern model, final JvmGenericType groupClass, final JvmGenericType matcherClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      String _name = model.getName();
      String _firstUpper = StringExtensions.toFirstUpper(_name);
      String _plus = ("get" + _firstUpper);
      JvmParameterizedTypeReference _createTypeRef = this._typeReferences.createTypeRef(matcherClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternGroupClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryEngine.class);
          JvmFormalParameter _parameter = PatternGroupClassInferrer.this._eMFJvmTypesBuilder.toParameter(matcherClass, "engine", _newTypeRef);
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              it.append(_builder);
              JvmParameterizedTypeReference _createTypeRef = PatternGroupClassInferrer.this._typeReferences.createTypeRef(matcherClass);
              PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, _createTypeRef, model);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(".on(engine);");
              it.append(_builder_1);
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, _createTypeRef, _function);
    }
    return _xblockexpression;
  }
}
