/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.annotations.PatternAnnotationProvider;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverDocumentationProvider;

public class EMFPatternLanguageHoverDocumentationProvider
extends XbaseHoverDocumentationProvider {
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private PatternAnnotationProvider annotationProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IEMFTypeProvider emfTypeProvider;

    public String computeDocumentation(EObject object) {
        if (object instanceof Annotation) {
            String description = this.annotationProvider.getDescription((Annotation)object);
            if (this.annotationProvider.isDeprecated((Annotation)object)) {
                return "<b>@deprecated</b></p></p>" + description;
            }
            return description;
        }
        if (object instanceof AnnotationParameter) {
            String description = this.annotationProvider.getDescription((AnnotationParameter)object);
            if (this.annotationProvider.isDeprecated((AnnotationParameter)object)) {
                return "<b>@deprecated</b></p></p>" + description;
            }
            return description;
        }
        if (object instanceof PackageImport) {
            PackageImport packageImport = (PackageImport)object;
            GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)packageImport, packageImport.getEPackage());
            if (genPackage != null) {
                return String.format("<b>Genmodel found</b>: %s<br/><b>Package uri</b>: %s", genPackage.eResource().getURI().toString(), genPackage.getEcorePackage().eResource().getURI().toString());
            }
        } else {
            if (object instanceof Variable) {
                Variable variable = (Variable)object;
                return this.calculateVariableHover(variable);
            }
            if (object instanceof VariableReference) {
                VariableReference reference = (VariableReference)object;
                return this.calculateVariableHover(reference.getVariable());
            }
        }
        return super.computeDocumentation(object);
    }

    private String calculateVariableHover(Variable variable) {
        String emfTypeString;
        JvmTypeReference type = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)variable);
        EClassifier emfType = this.emfTypeProvider.getClassifierForVariable(variable);
        String javaTypeString = type.getQualifiedName();
        if (emfType == null) {
            emfTypeString = "Not applicable";
        } else {
            String packageUri = emfType.getEPackage() != null ? "(<i>" + emfType.getEPackage().getNsURI() + "</i>)" : "";
            emfTypeString = String.format("%s %s", emfType.getName(), packageUri);
        }
        return String.format("<b>EMF Type</b>: %s<br /><b>Java Type</b>: %s", emfTypeString, javaTypeString);
    }
}

