/**
 * Copyright (c) 2010-2012, Abel Hegedus, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.incquery.querybasedfeatures.tooling;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.QueryBasedFeatures;
import org.eclipse.incquery.querybasedfeatures.tooling.ProjectLocator;
import org.eclipse.incquery.querybasedfeatures.tooling.QueryBasedFeatureGenerator;
import org.eclipse.incquery.querybasedfeatures.tooling.QueryBasedFeatureParameters;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ModelCodeBasedGenerator {
  @Extension
  private QueryBasedFeatureGenerator gen;
  
  /**
   * usage: @DerivedFeature(
   * 			feature="featureName", (default: patten name)
   * 			source="Src" (default: first parameter),
   * 			target="Trg" (default: second parameter),
   * 			kind="single/many/counter/sum/iteration" (default: feature.isMany?many:single)
   * 			keepCache="true/false" (default: true)
   * 		  )
   */
  private static String IMPORT_QUALIFIER = "org.eclipse.incquery.querybasedfeatures.runtime";
  
  private static String FEATUREKIND_IMPORT = "QueryBasedFeatureKind";
  
  private static String HELPER_IMPORT = "QueryBasedFeatureHelper";
  
  private static String HANDLER_NAME = "IQueryBasedFeatureHandler";
  
  private static String HANDLER_FIELD_SUFFIX = "Handler";
  
  public ModelCodeBasedGenerator(final QueryBasedFeatureGenerator generator) {
    this.gen = generator;
  }
  
  protected void processJavaFiles(final Pattern pattern, final Annotation annotation, final boolean generate) {
    try {
      try {
        final QueryBasedFeatureParameters parameters = this.gen.processDerivedFeatureAnnotation(pattern, annotation, generate);
        final GenPackage pckg = this.gen.provider.findGenPackage(pattern, parameters.ePackage);
        boolean _equals = Objects.equal(pckg, null);
        if (_equals) {
          if (generate) {
            this.gen.errorFeedback.reportError(pattern, "GenPackage not found!", QueryBasedFeatureGenerator.DERIVED_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
          }
          String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
          String _plus = ("Query-based feature pattern " + _fullyQualifiedName);
          String _plus_1 = (_plus + ": GenPackage not found!");
          throw new IllegalArgumentException(_plus_1);
        }
        final EClass source = parameters.source;
        final EStructuralFeature feature = parameters.feature;
        final GenClass genSourceClass = this.findGenClassForSource(pckg, source, pattern);
        final GenFeature genFeature = this.findGenFeatureForFeature(genSourceClass, feature, pattern);
        final IJavaProject javaProject = this.findJavaProject(pckg);
        boolean _equals_1 = Objects.equal(javaProject, null);
        if (_equals_1) {
          String _nSURI = pckg.getNSURI();
          String _plus_2 = ("Model project for GenPackage " + _nSURI);
          String _plus_3 = (_plus_2 + " not found!");
          this.gen.errorFeedback.reportError(pattern, _plus_3, QueryBasedFeatureGenerator.DERIVED_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
          String _fullyQualifiedName_1 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
          String _plus_4 = ("Derived feature pattern " + _fullyQualifiedName_1);
          String _plus_5 = (_plus_4 + ": Model project for GenPackage ");
          String _nSURI_1 = pckg.getNSURI();
          String _plus_6 = (_plus_5 + _nSURI_1);
          String _plus_7 = (_plus_6 + " not found!");
          throw new IllegalArgumentException(_plus_7);
        }
        final ICompilationUnit compunit = this.findJavaFile(pckg, genSourceClass, javaProject);
        final String docSource = compunit.getSource();
        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        final Document document = new Document(docSource);
        parser.setSource(compunit);
        ASTNode _createAST = parser.createAST(null);
        final CompilationUnit astNode = ((CompilationUnit) _createAST);
        final AST ast = astNode.getAST();
        final ASTRewrite rewrite = ASTRewrite.create(ast);
        List _types = astNode.types();
        final List<AbstractTypeDeclaration> types = ((List<AbstractTypeDeclaration>) _types);
        final Function1<AbstractTypeDeclaration, Boolean> _function = new Function1<AbstractTypeDeclaration, Boolean>() {
          public Boolean apply(final AbstractTypeDeclaration it) {
            boolean _xblockexpression = false;
            {
              final AbstractTypeDeclaration type = ((AbstractTypeDeclaration) it);
              SimpleName _name = type.getName();
              String _identifier = _name.getIdentifier();
              String _className = genSourceClass.getClassName();
              _xblockexpression = Objects.equal(_identifier, _className);
            }
            return Boolean.valueOf(_xblockexpression);
          }
        };
        AbstractTypeDeclaration _findFirst = IterableExtensions.<AbstractTypeDeclaration>findFirst(types, _function);
        final TypeDeclaration type = ((TypeDeclaration) _findFirst);
        final ListRewrite bodyDeclListRewrite = rewrite.getListRewrite(type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        final EStructuralFeature feat = genFeature.getEcoreFeature();
        if (generate) {
          this.ensureImports(ast, rewrite, astNode, type);
          this.ensureHandlerField(ast, bodyDeclListRewrite, type, genFeature);
          this.ensureGetterMethod(ast, document, type, rewrite, bodyDeclListRewrite, genSourceClass, genFeature, pattern, parameters);
          try {
            EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
            final ArrayList<EAnnotation> annotations = new ArrayList<EAnnotation>(_eAnnotations);
            final Procedure1<EAnnotation> _function_1 = new Procedure1<EAnnotation>() {
              public void apply(final EAnnotation it) {
                String _source = it.getSource();
                boolean _equals = Objects.equal(_source, QueryBasedFeatures.ANNOTATION_SOURCE);
                if (_equals) {
                  EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
                  _eAnnotations.remove(it);
                }
              }
            };
            IterableExtensions.<EAnnotation>forEach(annotations, _function_1);
            final EAnnotation ecoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            ecoreAnnotation.setSource(QueryBasedFeatures.ANNOTATION_SOURCE);
            EList<EAnnotation> _eAnnotations_1 = feat.getEAnnotations();
            _eAnnotations_1.add(ecoreAnnotation);
            EClass _eStringToStringMapEntry = EcorePackage.eINSTANCE.getEStringToStringMapEntry();
            EObject _create = EcoreFactory.eINSTANCE.create(_eStringToStringMapEntry);
            final BasicEMap.Entry<String, String> entry = ((BasicEMap.Entry<String, String>) _create);
            entry.setKey(QueryBasedFeatures.PATTERN_FQN_KEY);
            String _fullyQualifiedName_2 = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
            entry.setValue(_fullyQualifiedName_2);
            EMap<String, String> _details = ecoreAnnotation.getDetails();
            _details.add(entry);
          } catch (final Throwable _t) {
            if (_t instanceof Exception) {
              final Exception e = (Exception)_t;
              this.gen.logger.warn("Error happened when trying to edit Ecore file!", e);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        } else {
          String _name = genFeature.getName();
          this.removeHandlerField(ast, bodyDeclListRewrite, type, _name);
          this.restoreGetterMethod(ast, document, compunit, type, rewrite, bodyDeclListRewrite, genSourceClass, genFeature);
          try {
            EList<EAnnotation> _eAnnotations_2 = feat.getEAnnotations();
            final ArrayList<EAnnotation> annotations_1 = new ArrayList<EAnnotation>(_eAnnotations_2);
            final Procedure1<EAnnotation> _function_2 = new Procedure1<EAnnotation>() {
              public void apply(final EAnnotation it) {
                String _source = it.getSource();
                boolean _equals = Objects.equal(_source, QueryBasedFeatures.ANNOTATION_SOURCE);
                if (_equals) {
                  EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
                  _eAnnotations.remove(it);
                }
              }
            };
            IterableExtensions.<EAnnotation>forEach(annotations_1, _function_2);
          } catch (final Throwable _t_1) {
            if (_t_1 instanceof Exception) {
              final Exception e_1 = (Exception)_t_1;
              this.gen.logger.warn("Error happened when trying to edit Ecore file!", e_1);
            } else {
              throw Exceptions.sneakyThrow(_t_1);
            }
          }
        }
        try {
          Resource _eResource = feat.eResource();
          _eResource.save(null);
        } catch (final Throwable _t_2) {
          if (_t_2 instanceof IOException) {
            final IOException e_2 = (IOException)_t_2;
            this.gen.logger.warn("Error happened when trying to save Ecore file!", e_2);
          } else {
            throw Exceptions.sneakyThrow(_t_2);
          }
        }
        Map _options = javaProject.getOptions(true);
        final TextEdit edits = rewrite.rewriteAST(document, _options);
        edits.apply(document);
        final String newSource = document.get();
        IBuffer _buffer = compunit.getBuffer();
        _buffer.setContents(newSource);
        IBuffer _buffer_1 = compunit.getBuffer();
        _buffer_1.save(null, false);
      } catch (final Throwable _t_3) {
        if (_t_3 instanceof IllegalArgumentException) {
          final IllegalArgumentException e_3 = (IllegalArgumentException)_t_3;
          if (generate) {
            String _message = e_3.getMessage();
            this.gen.logger.error(_message, e_3);
          }
        } else {
          throw Exceptions.sneakyThrow(_t_3);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private GenClass findGenClassForSource(final GenPackage pckg, final EClass source, final Pattern pattern) {
    EList<GenClass> _genClasses = pckg.getGenClasses();
    final Function1<GenClass, Boolean> _function = new Function1<GenClass, Boolean>() {
      public Boolean apply(final GenClass it) {
        boolean _xblockexpression = false;
        {
          final EClass cls = it.getEcoreClass();
          String _name = cls.getName();
          String _name_1 = source.getName();
          _xblockexpression = Objects.equal(_name, _name_1);
        }
        return Boolean.valueOf(_xblockexpression);
      }
    };
    final GenClass genSourceClass = IterableExtensions.<GenClass>findFirst(_genClasses, _function);
    boolean _equals = Objects.equal(genSourceClass, null);
    if (_equals) {
      String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus = ("Derived feature pattern " + _fullyQualifiedName);
      String _plus_1 = (_plus + ": Source EClass ");
      String _name = source.getName();
      String _plus_2 = (_plus_1 + _name);
      String _plus_3 = (_plus_2 + " not found in GenPackage ");
      String _plus_4 = (_plus_3 + pckg);
      String _plus_5 = (_plus_4 + "!");
      throw new IllegalArgumentException(_plus_5);
    }
    return genSourceClass;
  }
  
  private GenFeature findGenFeatureForFeature(final GenClass genSourceClass, final EStructuralFeature feature, final Pattern pattern) {
    EList<GenFeature> _genFeatures = genSourceClass.getGenFeatures();
    final Function1<GenFeature, Boolean> _function = new Function1<GenFeature, Boolean>() {
      public Boolean apply(final GenFeature it) {
        boolean _xblockexpression = false;
        {
          final EStructuralFeature feat = it.getEcoreFeature();
          String _name = feat.getName();
          String _name_1 = feature.getName();
          _xblockexpression = Objects.equal(_name, _name_1);
        }
        return Boolean.valueOf(_xblockexpression);
      }
    };
    final GenFeature genFeature = IterableExtensions.<GenFeature>findFirst(_genFeatures, _function);
    boolean _equals = Objects.equal(genFeature, null);
    if (_equals) {
      String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
      String _plus = ("Derived feature pattern " + _fullyQualifiedName);
      String _plus_1 = (_plus + ": Feature ");
      String _name = feature.getName();
      String _plus_2 = (_plus_1 + _name);
      String _plus_3 = (_plus_2 + " not found in GenClass ");
      String _name_1 = genSourceClass.getName();
      String _plus_4 = (_plus_3 + _name_1);
      String _plus_5 = (_plus_4 + "!");
      throw new IllegalArgumentException(_plus_5);
    }
    return genFeature;
  }
  
  private IJavaProject findJavaProject(final GenPackage pckg) {
    IJavaProject _xblockexpression = null;
    {
      GenModel _genModel = pckg.getGenModel();
      final String projectDir = _genModel.getModelProjectDirectory();
      _xblockexpression = ProjectLocator.locateProject(projectDir, this.gen.logger);
    }
    return _xblockexpression;
  }
  
  private ICompilationUnit findJavaFile(final GenPackage pckg, final GenClass genSourceClass, final IJavaProject javaProject) {
    try {
      ICompilationUnit _xblockexpression = null;
      {
        EPackage _ecorePackage = pckg.getEcorePackage();
        final String prefix = _ecorePackage.getName();
        final String suffix = pckg.getClassPackageSuffix();
        final String base = pckg.getBasePackage();
        String packageNameTmp = "";
        boolean _and = false;
        boolean _notEquals = (!Objects.equal(base, null));
        if (!_notEquals) {
          _and = false;
        } else {
          boolean _notEquals_1 = (!Objects.equal(base, ""));
          _and = _notEquals_1;
        }
        if (_and) {
          packageNameTmp = base;
        }
        boolean _and_1 = false;
        boolean _notEquals_2 = (!Objects.equal(prefix, null));
        if (!_notEquals_2) {
          _and_1 = false;
        } else {
          boolean _notEquals_3 = (!Objects.equal(prefix, ""));
          _and_1 = _notEquals_3;
        }
        if (_and_1) {
          boolean _notEquals_4 = (!Objects.equal(packageNameTmp, ""));
          if (_notEquals_4) {
            packageNameTmp = ((packageNameTmp + ".") + prefix);
          } else {
            packageNameTmp = prefix;
          }
        }
        boolean _and_2 = false;
        boolean _notEquals_5 = (!Objects.equal(suffix, null));
        if (!_notEquals_5) {
          _and_2 = false;
        } else {
          boolean _notEquals_6 = (!Objects.equal(suffix, ""));
          _and_2 = _notEquals_6;
        }
        if (_and_2) {
          boolean _notEquals_7 = (!Objects.equal(packageNameTmp, ""));
          if (_notEquals_7) {
            packageNameTmp = ((packageNameTmp + ".") + suffix);
          } else {
            packageNameTmp = suffix;
          }
        }
        final String packageName = packageNameTmp;
        IPackageFragment[] _packageFragments = javaProject.getPackageFragments();
        final Function1<IPackageFragment, Boolean> _function = new Function1<IPackageFragment, Boolean>() {
          public Boolean apply(final IPackageFragment it) {
            String _elementName = it.getElementName();
            return Boolean.valueOf(Objects.equal(_elementName, packageName));
          }
        };
        final IPackageFragment implPackage = IterableExtensions.<IPackageFragment>findFirst(((Iterable<IPackageFragment>)Conversions.doWrapArray(_packageFragments)), _function);
        boolean _equals = Objects.equal(implPackage, null);
        if (_equals) {
          throw new IllegalArgumentException((("Derived feature generation: Implementation package " + packageName) + " not found!"));
        }
        ICompilationUnit[] _compilationUnits = implPackage.getCompilationUnits();
        final Function1<ICompilationUnit, Boolean> _function_1 = new Function1<ICompilationUnit, Boolean>() {
          public Boolean apply(final ICompilationUnit it) {
            String _elementName = it.getElementName();
            String _className = genSourceClass.getClassName();
            String _plus = (_className + ".java");
            return Boolean.valueOf(Objects.equal(_elementName, _plus));
          }
        };
        _xblockexpression = IterableExtensions.<ICompilationUnit>findFirst(((Iterable<ICompilationUnit>)Conversions.doWrapArray(_compilationUnits)), _function_1);
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void ensureImports(final AST ast, final ASTRewrite rewrite, final CompilationUnit astNode, final TypeDeclaration type) {
    final ListRewrite importListRewrite = rewrite.getListRewrite(astNode, CompilationUnit.IMPORTS_PROPERTY);
    List _imports = astNode.imports();
    final List<ImportDeclaration> imports = ((List<ImportDeclaration>) _imports);
    final Function1<ImportDeclaration, Boolean> _function = new Function1<ImportDeclaration, Boolean>() {
      public Boolean apply(final ImportDeclaration it) {
        Name _name = it.getName();
        String _fullyQualifiedName = _name.getFullyQualifiedName();
        return Boolean.valueOf(Objects.equal(_fullyQualifiedName, ((ModelCodeBasedGenerator.IMPORT_QUALIFIER + ".") + ModelCodeBasedGenerator.HANDLER_NAME)));
      }
    };
    final ImportDeclaration handlerImport = IterableExtensions.<ImportDeclaration>findFirst(imports, _function);
    boolean _equals = Objects.equal(handlerImport, null);
    if (_equals) {
      final ImportDeclaration handlerImportNew = ast.newImportDeclaration();
      Name _newName = ast.newName(ModelCodeBasedGenerator.IMPORT_QUALIFIER);
      SimpleName _newSimpleName = ast.newSimpleName(ModelCodeBasedGenerator.HANDLER_NAME);
      QualifiedName _newQualifiedName = ast.newQualifiedName(_newName, _newSimpleName);
      handlerImportNew.setName(_newQualifiedName);
      importListRewrite.insertLast(handlerImportNew, null);
    }
    final Function1<ImportDeclaration, Boolean> _function_1 = new Function1<ImportDeclaration, Boolean>() {
      public Boolean apply(final ImportDeclaration it) {
        Name _name = it.getName();
        String _fullyQualifiedName = _name.getFullyQualifiedName();
        return Boolean.valueOf(Objects.equal(_fullyQualifiedName, ((ModelCodeBasedGenerator.IMPORT_QUALIFIER + ".") + ModelCodeBasedGenerator.FEATUREKIND_IMPORT)));
      }
    };
    final ImportDeclaration kindImport = IterableExtensions.<ImportDeclaration>findFirst(imports, _function_1);
    boolean _equals_1 = Objects.equal(kindImport, null);
    if (_equals_1) {
      final ImportDeclaration kindImportNew = ast.newImportDeclaration();
      Name _newName_1 = ast.newName(ModelCodeBasedGenerator.IMPORT_QUALIFIER);
      SimpleName _newSimpleName_1 = ast.newSimpleName(ModelCodeBasedGenerator.FEATUREKIND_IMPORT);
      QualifiedName _newQualifiedName_1 = ast.newQualifiedName(_newName_1, _newSimpleName_1);
      kindImportNew.setName(_newQualifiedName_1);
      importListRewrite.insertLast(kindImportNew, null);
    }
    final Function1<ImportDeclaration, Boolean> _function_2 = new Function1<ImportDeclaration, Boolean>() {
      public Boolean apply(final ImportDeclaration it) {
        Name _name = it.getName();
        String _fullyQualifiedName = _name.getFullyQualifiedName();
        return Boolean.valueOf(Objects.equal(_fullyQualifiedName, ((ModelCodeBasedGenerator.IMPORT_QUALIFIER + ".") + ModelCodeBasedGenerator.HELPER_IMPORT)));
      }
    };
    final ImportDeclaration helperImport = IterableExtensions.<ImportDeclaration>findFirst(imports, _function_2);
    boolean _equals_2 = Objects.equal(helperImport, null);
    if (_equals_2) {
      final ImportDeclaration helperImportNew = ast.newImportDeclaration();
      Name _newName_2 = ast.newName(ModelCodeBasedGenerator.IMPORT_QUALIFIER);
      SimpleName _newSimpleName_2 = ast.newSimpleName(ModelCodeBasedGenerator.HELPER_IMPORT);
      QualifiedName _newQualifiedName_2 = ast.newQualifiedName(_newName_2, _newSimpleName_2);
      helperImportNew.setName(_newQualifiedName_2);
      importListRewrite.insertLast(helperImportNew, null);
    }
  }
  
  private void ensureHandlerField(final AST ast, final ListRewrite bodyDeclListRewrite, final TypeDeclaration type, final GenFeature feature) {
    FieldDeclaration[] _fields = type.getFields();
    final Function1<FieldDeclaration, Boolean> _function = new Function1<FieldDeclaration, Boolean>() {
      public Boolean apply(final FieldDeclaration it) {
        boolean _xblockexpression = false;
        {
          List _fragments = it.fragments();
          final List<VariableDeclarationFragment> fragments = ((List<VariableDeclarationFragment>) _fragments);
          final Function1<VariableDeclarationFragment, Boolean> _function = new Function1<VariableDeclarationFragment, Boolean>() {
            public Boolean apply(final VariableDeclarationFragment it) {
              SimpleName _name = it.getName();
              String _identifier = _name.getIdentifier();
              String _name_1 = feature.getName();
              String _plus = (_name_1 + ModelCodeBasedGenerator.HANDLER_FIELD_SUFFIX);
              return Boolean.valueOf(Objects.equal(_identifier, _plus));
            }
          };
          _xblockexpression = IterableExtensions.<VariableDeclarationFragment>exists(fragments, _function);
        }
        return Boolean.valueOf(_xblockexpression);
      }
    };
    final FieldDeclaration handler = IterableExtensions.<FieldDeclaration>findFirst(((Iterable<FieldDeclaration>)Conversions.doWrapArray(_fields)), _function);
    boolean _equals = Objects.equal(handler, null);
    if (_equals) {
      final VariableDeclarationFragment handlerFragment = ast.newVariableDeclarationFragment();
      String _name = feature.getName();
      String _plus = (_name + ModelCodeBasedGenerator.HANDLER_FIELD_SUFFIX);
      SimpleName _newSimpleName = ast.newSimpleName(_plus);
      handlerFragment.setName(_newSimpleName);
      final FieldDeclaration handlerField = ast.newFieldDeclaration(handlerFragment);
      SimpleName _newSimpleName_1 = ast.newSimpleName(ModelCodeBasedGenerator.HANDLER_NAME);
      final SimpleType handlerType = ast.newSimpleType(_newSimpleName_1);
      handlerField.setType(handlerType);
      List _modifiers = handlerField.modifiers();
      Modifier _newModifier = ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
      _modifiers.add(_newModifier);
      final TagElement handlerTag = ast.newTagElement();
      final TextElement tagText = ast.newTextElement();
      String _name_1 = feature.getName();
      String _plus_1 = ("EMF-IncQuery handler for query-based feature " + _name_1);
      tagText.setText(_plus_1);
      List _fragments = handlerTag.fragments();
      _fragments.add(tagText);
      final Javadoc javaDoc = ast.newJavadoc();
      List _tags = javaDoc.tags();
      _tags.add(handlerTag);
      handlerField.setJavadoc(javaDoc);
      bodyDeclListRewrite.insertLast(handlerField, null);
    }
  }
  
  private void removeHandlerField(final AST ast, final ListRewrite bodyDeclListRewrite, final TypeDeclaration type, final String featureName) {
    FieldDeclaration[] _fields = type.getFields();
    final Function1<FieldDeclaration, Boolean> _function = new Function1<FieldDeclaration, Boolean>() {
      public Boolean apply(final FieldDeclaration it) {
        boolean _xblockexpression = false;
        {
          List _fragments = it.fragments();
          final List<VariableDeclarationFragment> fragments = ((List<VariableDeclarationFragment>) _fragments);
          final Function1<VariableDeclarationFragment, Boolean> _function = new Function1<VariableDeclarationFragment, Boolean>() {
            public Boolean apply(final VariableDeclarationFragment it) {
              SimpleName _name = it.getName();
              String _identifier = _name.getIdentifier();
              return Boolean.valueOf(Objects.equal(_identifier, (featureName + ModelCodeBasedGenerator.HANDLER_FIELD_SUFFIX)));
            }
          };
          _xblockexpression = IterableExtensions.<VariableDeclarationFragment>exists(fragments, _function);
        }
        return Boolean.valueOf(_xblockexpression);
      }
    };
    final FieldDeclaration handler = IterableExtensions.<FieldDeclaration>findFirst(((Iterable<FieldDeclaration>)Conversions.doWrapArray(_fields)), _function);
    boolean _notEquals = (!Objects.equal(handler, null));
    if (_notEquals) {
      bodyDeclListRewrite.remove(handler, null);
    }
  }
  
  private void ensureGetterMethod(final AST ast, final Document document, final TypeDeclaration type, final ASTRewrite rewrite, final ListRewrite bodyDeclListRewrite, final GenClass sourceClass, final GenFeature genFeature, final Pattern pattern, final QueryBasedFeatureParameters parameters) {
    final String sourceName = parameters.sourceVar;
    final String targetName = parameters.targetVar;
    final QueryBasedFeatureKind kind = parameters.kind;
    final boolean keepCache = parameters.keepCache;
    final MethodDeclaration getMethod = this.findFeatureMethod(type, genFeature, "");
    final MethodDeclaration getGenMethod = this.findFeatureMethod(type, genFeature, "Gen");
    CharSequence methodSource = this.gen.codeGen.methodBody(sourceClass, genFeature, pattern, sourceName, targetName, kind, keepCache);
    String _string = methodSource.toString();
    MethodDeclaration dummyMethod = this.processDummyComputationUnit(_string);
    boolean _notEquals = (!Objects.equal(getMethod, null));
    if (_notEquals) {
      final Javadoc javadoc = getMethod.getJavadoc();
      boolean generatedBody = false;
      boolean _notEquals_1 = (!Objects.equal(javadoc, null));
      if (_notEquals_1) {
        List _tags = javadoc.tags();
        final List<TagElement> tags = ((List<TagElement>) _tags);
        final Function1<TagElement, Boolean> _function = new Function1<TagElement, Boolean>() {
          public Boolean apply(final TagElement it) {
            String _tagName = ((TagElement) it).getTagName();
            return Boolean.valueOf(Objects.equal(_tagName, "@generated"));
          }
        };
        final TagElement generatedTag = IterableExtensions.<TagElement>findFirst(tags, _function);
        final Function1<TagElement, Boolean> _function_1 = new Function1<TagElement, Boolean>() {
          public Boolean apply(final TagElement it) {
            String _tagName = ((TagElement) it).getTagName();
            return Boolean.valueOf(Objects.equal(_tagName, "@query-based"));
          }
        };
        final TagElement derivedTag = IterableExtensions.<TagElement>findFirst(tags, _function_1);
        boolean _and = false;
        boolean _and_1 = false;
        boolean _equals = Objects.equal(derivedTag, null);
        if (!_equals) {
          _and_1 = false;
        } else {
          boolean _notEquals_2 = (!Objects.equal(generatedTag, null));
          _and_1 = _notEquals_2;
        }
        if (!_and_1) {
          _and = false;
        } else {
          List _fragments = generatedTag.fragments();
          int _size = _fragments.size();
          boolean _equals_1 = (_size == 0);
          _and = _equals_1;
        }
        if (_and) {
          generatedBody = true;
          SimpleName _name = getMethod.getName();
          final String methodName = _name.getIdentifier();
          ASTNode _copySubtree = ASTNode.copySubtree(ast, getMethod);
          final MethodDeclaration method = ((MethodDeclaration) _copySubtree);
          SimpleName _name_1 = method.getName();
          SimpleName _newSimpleName = ast.newSimpleName(methodName);
          rewrite.replace(_name_1, _newSimpleName, null);
          Block _body = method.getBody();
          Block _body_1 = dummyMethod.getBody();
          rewrite.replace(_body, _body_1, null);
          Javadoc _javadoc = method.getJavadoc();
          List _tags_1 = _javadoc.tags();
          final List<TagElement> methodtags = ((List<TagElement>) _tags_1);
          final Function1<TagElement, Boolean> _function_2 = new Function1<TagElement, Boolean>() {
            public Boolean apply(final TagElement it) {
              String _tagName = ((TagElement) it).getTagName();
              return Boolean.valueOf(Objects.equal(_tagName, "@generated"));
            }
          };
          final TagElement oldTag = IterableExtensions.<TagElement>findFirst(methodtags, _function_2);
          rewrite.set(oldTag, TagElement.TAG_NAME_PROPERTY, "@query-based", null);
          final ListRewrite tagsRewrite = rewrite.getListRewrite(oldTag, TagElement.FRAGMENTS_PROPERTY);
          final TextElement tagText = ast.newTextElement();
          String _name_2 = genFeature.getName();
          String _plus = ("getter created by EMF-IncQuery for query-based feature " + _name_2);
          tagText.setText(_plus);
          tagsRewrite.insertLast(tagText, null);
          bodyDeclListRewrite.insertLast(method, null);
          boolean _equals_2 = Objects.equal(getGenMethod, null);
          if (_equals_2) {
            SimpleName _name_3 = getMethod.getName();
            SimpleName _name_4 = getMethod.getName();
            String _identifier = _name_4.getIdentifier();
            String _plus_1 = (_identifier + "Gen");
            SimpleName _newSimpleName_1 = ast.newSimpleName(_plus_1);
            rewrite.replace(_name_3, _newSimpleName_1, null);
          } else {
            SimpleName _name_5 = getMethod.getName();
            SimpleName _name_6 = getMethod.getName();
            String _identifier_1 = _name_6.getIdentifier();
            String _plus_2 = ("_" + _identifier_1);
            SimpleName _newSimpleName_2 = ast.newSimpleName(_plus_2);
            rewrite.replace(_name_5, _newSimpleName_2, null);
          }
        }
        boolean _notEquals_3 = (!Objects.equal(derivedTag, null));
        if (_notEquals_3) {
          generatedBody = true;
          Block _body_2 = getMethod.getBody();
          Block _body_3 = dummyMethod.getBody();
          this.replaceMethodBody(ast, rewrite, _body_2, _body_3, javadoc, document, false, null, null, null);
        }
      }
      if ((!generatedBody)) {
        Block _body_4 = getMethod.getBody();
        Block _body_5 = dummyMethod.getBody();
        String _name_7 = genFeature.getName();
        String _plus_3 = ("getter created by EMF-IncQuery for query-based feature " + _name_7);
        this.replaceMethodBody(ast, rewrite, _body_4, _body_5, javadoc, document, true, "@query-based", _plus_3, null);
      }
    }
  }
  
  private void restoreGetterMethod(final AST ast, final Document document, final ICompilationUnit compunit, final TypeDeclaration type, final ASTRewrite rewrite, final ListRewrite bodyDeclListRewrite, final GenClass sourceClass, final GenFeature genFeature) {
    final MethodDeclaration getMethod = this.findFeatureMethod(type, genFeature, "");
    final MethodDeclaration getGenMethod = this.findFeatureMethod(type, genFeature, "Gen");
    boolean _notEquals = (!Objects.equal(getGenMethod, null));
    if (_notEquals) {
      boolean _notEquals_1 = (!Objects.equal(getMethod, null));
      if (_notEquals_1) {
        SimpleName _name = getGenMethod.getName();
        SimpleName _name_1 = getMethod.getName();
        String _identifier = _name_1.getIdentifier();
        SimpleName _newSimpleName = ast.newSimpleName(_identifier);
        rewrite.replace(_name, _newSimpleName, null);
        bodyDeclListRewrite.remove(getMethod, null);
      }
    } else {
      EStructuralFeature _ecoreFeature = genFeature.getEcoreFeature();
      boolean _isMany = _ecoreFeature.isMany();
      CharSequence methodSource = this.gen.codeGen.defaultMethod(_isMany);
      String _string = methodSource.toString();
      MethodDeclaration dummyMethod = this.processDummyComputationUnit(_string);
      boolean _notEquals_2 = (!Objects.equal(getMethod, null));
      if (_notEquals_2) {
        final Javadoc javadoc = getMethod.getJavadoc();
        boolean _notEquals_3 = (!Objects.equal(javadoc, null));
        if (_notEquals_3) {
          List _tags = javadoc.tags();
          final List<TagElement> tags = ((List<TagElement>) _tags);
          final Function1<TagElement, Boolean> _function = new Function1<TagElement, Boolean>() {
            public Boolean apply(final TagElement it) {
              String _tagName = ((TagElement) it).getTagName();
              return Boolean.valueOf(Objects.equal(_tagName, "@query-basedd"));
            }
          };
          final TagElement derivedTag = IterableExtensions.<TagElement>findFirst(tags, _function);
          final Function1<TagElement, Boolean> _function_1 = new Function1<TagElement, Boolean>() {
            public Boolean apply(final TagElement it) {
              String _tagName = ((TagElement) it).getTagName();
              return Boolean.valueOf(Objects.equal(_tagName, "@original"));
            }
          };
          final TagElement originalTag = IterableExtensions.<TagElement>findFirst(tags, _function_1);
          final Function1<TagElement, Boolean> _function_2 = new Function1<TagElement, Boolean>() {
            public Boolean apply(final TagElement it) {
              String _tagName = ((TagElement) it).getTagName();
              return Boolean.valueOf(Objects.equal(_tagName, "@generated"));
            }
          };
          final TagElement generatedTag = IterableExtensions.<TagElement>findFirst(tags, _function_2);
          boolean _and = false;
          boolean _notEquals_4 = (!Objects.equal(generatedTag, null));
          if (!_notEquals_4) {
            _and = false;
          } else {
            List _fragments = generatedTag.fragments();
            int _size = _fragments.size();
            boolean _equals = (_size == 0);
            _and = _equals;
          }
          if (_and) {
            return;
          }
          boolean _and_1 = false;
          boolean _notEquals_5 = (!Objects.equal(derivedTag, null));
          if (!_notEquals_5) {
            _and_1 = false;
          } else {
            boolean _notEquals_6 = (!Objects.equal(originalTag, null));
            _and_1 = _notEquals_6;
          }
          if (_and_1) {
            List _fragments_1 = originalTag.fragments();
            int _size_1 = _fragments_1.size();
            boolean _notEquals_7 = (_size_1 != 0);
            if (_notEquals_7) {
              final ListRewrite tagsRewrite = rewrite.getListRewrite(javadoc, Javadoc.TAGS_PROPERTY);
              tagsRewrite.remove(derivedTag, null);
              final List tagFragments = originalTag.fragments();
              final StringBuilder oldBody = new StringBuilder();
              for (final Object o : tagFragments) {
                if ((o instanceof TextElement)) {
                  String _text = ((TextElement) o).getText();
                  oldBody.append(_text);
                }
              }
              final MethodDeclaration oldMethod = this.prepareOriginalMethod(compunit, type, getMethod, oldBody);
              Block _body = getMethod.getBody();
              Block _body_1 = oldMethod.getBody();
              rewrite.replace(_body, _body_1, null);
              tagsRewrite.remove(originalTag, null);
              return;
            }
          }
          boolean _notEquals_8 = (!Objects.equal(generatedTag, null));
          if (_notEquals_8) {
            return;
          }
        }
        Block _body_2 = getMethod.getBody();
        Block _body_3 = dummyMethod.getBody();
        this.replaceMethodBody(ast, rewrite, _body_2, _body_3, javadoc, document, false, "@generated", "", "@query-based");
      }
    }
  }
  
  private MethodDeclaration findFeatureMethod(final TypeDeclaration type, final GenFeature genFeature, final String suffix) {
    MethodDeclaration[] _methods = type.getMethods();
    final Function1<MethodDeclaration, Boolean> _function = new Function1<MethodDeclaration, Boolean>() {
      public Boolean apply(final MethodDeclaration it) {
        boolean _xifexpression = false;
        boolean _isBasicGet = genFeature.isBasicGet();
        if (_isBasicGet) {
          SimpleName _name = it.getName();
          String _identifier = _name.getIdentifier();
          String _getAccessor = genFeature.getGetAccessor();
          String _firstUpper = StringExtensions.toFirstUpper(_getAccessor);
          String _plus = ("basic" + _firstUpper);
          String _plus_1 = (_plus + suffix);
          _xifexpression = Objects.equal(_identifier, _plus_1);
        } else {
          SimpleName _name_1 = it.getName();
          String _identifier_1 = _name_1.getIdentifier();
          String _getAccessor_1 = genFeature.getGetAccessor();
          String _plus_2 = (_getAccessor_1 + suffix);
          _xifexpression = Objects.equal(_identifier_1, _plus_2);
        }
        return Boolean.valueOf(_xifexpression);
      }
    };
    return IterableExtensions.<MethodDeclaration>findFirst(((Iterable<MethodDeclaration>)Conversions.doWrapArray(_methods)), _function);
  }
  
  private MethodDeclaration processDummyComputationUnit(final String dummySource) {
    MethodDeclaration _xblockexpression = null;
    {
      final ASTParser methodBodyParser = ASTParser.newParser(AST.JLS3);
      char[] _charArray = dummySource.toCharArray();
      methodBodyParser.setSource(_charArray);
      final Hashtable options = JavaCore.getOptions();
      JavaCore.setComplianceOptions(JavaCore.VERSION_1_5, options);
      methodBodyParser.setCompilerOptions(options);
      final ASTNode dummyAST = methodBodyParser.createAST(null);
      final CompilationUnit dummyCU = ((CompilationUnit) dummyAST);
      List _types = dummyCU.types();
      Object _get = _types.get(0);
      final TypeDeclaration dummyType = ((TypeDeclaration) _get);
      MethodDeclaration[] _methods = dummyType.getMethods();
      MethodDeclaration _get_1 = _methods[0];
      _xblockexpression = ((MethodDeclaration) _get_1);
    }
    return _xblockexpression;
  }
  
  private MethodDeclaration prepareOriginalMethod(final ICompilationUnit cu, final TypeDeclaration type, final MethodDeclaration method, final StringBuilder originalBody) {
    try {
      MethodDeclaration _xblockexpression = null;
      {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public class Dummy{public void DummyMethod()");
        originalBody.insert(0, _builder);
        IImportDeclaration[] _imports = cu.getImports();
        final Procedure1<IImportDeclaration> _function = new Procedure1<IImportDeclaration>() {
          public void apply(final IImportDeclaration it) {
            try {
              String _source = it.getSource();
              String _plus = (_source + "\n");
              originalBody.insert(0, _plus);
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        };
        IterableExtensions.<IImportDeclaration>forEach(((Iterable<IImportDeclaration>)Conversions.doWrapArray(_imports)), _function);
        originalBody.append("}");
        final String dummyCU = originalBody.toString();
        _xblockexpression = this.processDummyComputationUnit(dummyCU);
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void replaceMethodBody(final AST ast, final ASTRewrite rewrite, final Block oldBody, final Block newBody, final Javadoc javadoc, final Document document, final boolean keepOld, final String newTagName, final String newTagText, final String removeTagName) {
    List _tags = javadoc.tags();
    final List<TagElement> tags = ((List<TagElement>) _tags);
    final ListRewrite tagsRewrite = rewrite.getListRewrite(javadoc, Javadoc.TAGS_PROPERTY);
    final Function1<TagElement, Boolean> _function = new Function1<TagElement, Boolean>() {
      public Boolean apply(final TagElement it) {
        String _tagName = ((TagElement) it).getTagName();
        return Boolean.valueOf(Objects.equal(_tagName, "@original"));
      }
    };
    final TagElement originalTag = IterableExtensions.<TagElement>findFirst(tags, _function);
    final Function1<TagElement, Boolean> _function_1 = new Function1<TagElement, Boolean>() {
      public Boolean apply(final TagElement it) {
        String _tagName = ((TagElement) it).getTagName();
        return Boolean.valueOf(Objects.equal(_tagName, newTagName));
      }
    };
    final TagElement newTag = IterableExtensions.<TagElement>findFirst(tags, _function_1);
    boolean _notEquals = (!Objects.equal(removeTagName, null));
    if (_notEquals) {
      final Function1<TagElement, Boolean> _function_2 = new Function1<TagElement, Boolean>() {
        public Boolean apply(final TagElement it) {
          String _tagName = ((TagElement) it).getTagName();
          return Boolean.valueOf(Objects.equal(_tagName, removeTagName));
        }
      };
      final TagElement removeTag = IterableExtensions.<TagElement>findFirst(tags, _function_2);
      boolean _notEquals_1 = (!Objects.equal(removeTag, null));
      if (_notEquals_1) {
        tagsRewrite.remove(removeTag, null);
      }
    }
    boolean _equals = Objects.equal(originalTag, null);
    if (_equals) {
      if (keepOld) {
        final TagElement tag = ast.newTagElement();
        tag.setTagName("@original");
        final TextElement text = ast.newTextElement();
        String _string = oldBody.toString();
        String _defaultLineDelimiter = document.getDefaultLineDelimiter();
        String _replace = _string.replace("\n", _defaultLineDelimiter);
        text.setText(_replace);
        List _fragments = tag.fragments();
        _fragments.add(text);
        tagsRewrite.insertLast(tag, null);
      }
    } else {
      if ((!keepOld)) {
        tagsRewrite.remove(originalTag, null);
      }
    }
    boolean _equals_1 = Objects.equal(newTag, null);
    if (_equals_1) {
      final TagElement newTagToInsert = ast.newTagElement();
      newTagToInsert.setTagName(newTagName);
      final TextElement tagText = ast.newTextElement();
      tagText.setText(newTagText);
      List _fragments_1 = newTagToInsert.fragments();
      _fragments_1.add(tagText);
      tagsRewrite.insertLast(newTagToInsert, null);
    }
    rewrite.replace(oldBody, newBody, null);
  }
}
