/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;

public abstract class LightweightEObjectObserverAdapter
implements LightweightEObjectObserver {
    private Collection<EStructuralFeature> observedFeatures;

    public LightweightEObjectObserverAdapter(Collection<EStructuralFeature> observedFeatures) {
        Preconditions.checkArgument((observedFeatures != null ? 1 : 0) != 0, (Object)"List of observed features must not be null!");
        this.observedFeatures = Sets.newHashSet(observedFeatures);
    }

    public void observeAdditionalFeature(EStructuralFeature observedFeature) {
        Preconditions.checkArgument((observedFeature != null ? 1 : 0) != 0, (Object)"Cannot observe null feature!");
        this.observedFeatures.add(observedFeature);
    }

    public void observeAdditionalFeatures(Collection<EStructuralFeature> observedFeatures) {
        Preconditions.checkArgument((observedFeatures != null ? 1 : 0) != 0, (Object)"List of additional observed features must not be null!");
        this.observedFeatures.addAll(observedFeatures);
    }

    public void removeObservedFeature(EStructuralFeature observedFeature) {
        Preconditions.checkArgument((observedFeature != null ? 1 : 0) != 0, (Object)"Cannot remove null observed feature!");
        this.observedFeatures.remove(observedFeature);
    }

    public void removeObservedFeatures(Collection<EStructuralFeature> observedFeatures) {
        Preconditions.checkArgument((observedFeatures != null ? 1 : 0) != 0, (Object)"List of observed features to remove must not be null!");
        this.observedFeatures.removeAll(observedFeatures);
    }

    @Override
    public void notifyFeatureChanged(EObject host, EStructuralFeature feature, Notification notification) {
        if (this.observedFeatures.contains(feature)) {
            this.observedFeatureUpdate(host, feature, notification);
        }
    }

    public abstract void observedFeatureUpdate(EObject var1, EStructuralFeature var2, Notification var3);
}

