/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Executor;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;

public final class EventDrivenVM {
    private EventDrivenVM() {
    }

    public static RuleEngine createRuleEngine(EventRealm eventRealm) {
        RuleBase ruleBase = new RuleBase(eventRealm);
        return RuleEngine.create(ruleBase);
    }

    public static ExecutionSchema createExecutionSchema(EventRealm eventRealm, Scheduler.ISchedulerFactory schedulerFactory, Set<RuleSpecification<?>> specifications) {
        Preconditions.checkNotNull((Object)schedulerFactory, (Object)"Cannot create execution schema with null scheduler factory");
        Preconditions.checkNotNull(specifications, (Object)"Cannot create execution schema with null rule specification set");
        Executor executor = new Executor(eventRealm);
        RuleBase ruleBase = executor.getRuleBase();
        for (RuleSpecification<?> specification : specifications) {
            EventDrivenVM.instantiateRuleInRuleBase(ruleBase, specification);
        }
        Scheduler scheduler = schedulerFactory.prepareScheduler(executor);
        return ExecutionSchema.create(scheduler);
    }

    private static <EventAtom> void instantiateRuleInRuleBase(RuleBase ruleBase, RuleSpecification<EventAtom> specification) {
        EventFilter<EventAtom> emptyFilter = specification.createEmptyFilter();
        ruleBase.instantiateRule(specification, emptyFilter);
    }
}

