/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.resolver;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictResolver;
import org.eclipse.incquery.runtime.evm.specific.resolver.FixedPriorityConflictSet;

public class InvertedDisappearancePriorityConflictResolver
extends FixedPriorityConflictResolver {
    @Override
    protected FixedPriorityConflictSet createReconfigurableConflictSet() {
        return new InvertedDisappearancePriorityConflictSet(this, this.priorities);
    }

    public class InvertedDisappearancePriorityConflictSet
    extends FixedPriorityConflictSet {
        public InvertedDisappearancePriorityConflictSet(FixedPriorityConflictResolver resolver, Map<RuleSpecification<?>, Integer> priorities) {
            super(resolver, priorities);
        }

        @Override
        protected Integer getRulePriority(Activation<?> activation) {
            if (IncQueryActivationStateEnum.DISAPPEARED.equals(activation.getState())) {
                return -1 * super.getRulePriority(activation);
            }
            return super.getRulePriority(activation);
        }

        @Override
        public boolean removeActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
            Integer rulePriority = this.getRulePriority(activation);
            return this.priorityBuckets.remove((Object)rulePriority, activation) || this.priorityBuckets.remove((Object)(-1 * rulePriority), activation);
        }
    }
}

