/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.context.surrogate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class SurrogateQueryRegistry {
    private Map<Object, PQuery> registeredSurrogateQueryMap = new WeakHashMap<Object, PQuery>();
    private Map<Object, PQuery> dynamicSurrogateQueryMap = new WeakHashMap<Object, PQuery>();
    private static final SurrogateQueryRegistry INSTANCE = new SurrogateQueryRegistry();

    private SurrogateQueryRegistry() {
    }

    public static SurrogateQueryRegistry instance() {
        return INSTANCE;
    }

    public PQuery registerSurrogateQueryForFeature(Object feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query must not be null!");
        return this.registeredSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public PQuery addDynamicSurrogateQueryForFeature(Object feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.dynamicSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public PQuery removeDynamicSurrogateQueryForFeature(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        return this.dynamicSurrogateQueryMap.remove(feature);
    }

    public boolean hasSurrogateQueryFQN(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        boolean surrogateExists = this.dynamicSurrogateQueryMap.containsKey(feature);
        if (!surrogateExists) {
            surrogateExists = this.registeredSurrogateQueryMap.containsKey(feature);
        }
        return surrogateExists;
    }

    public PQuery getSurrogateQuery(Object feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        PQuery surrogate = this.dynamicSurrogateQueryMap.get(feature);
        if (surrogate == null) {
            surrogate = this.registeredSurrogateQueryMap.get(feature);
        }
        if (surrogate != null) {
            return surrogate;
        }
        throw new NoSuchElementException(String.format("Feature %s has no surrogate query defined! Use #hasSurrogateQueryFQN to check existence.", feature));
    }

    public Map<Object, PQuery> getRegisteredSurrogateQueryFQNMap() {
        return this.registeredSurrogateQueryMap;
    }

    public Map<Object, PQuery> getDynamicSurrogateQueryFQNMap() {
        return this.dynamicSurrogateQueryMap;
    }

    public Map<Object, PQuery> getAllSurrogateQueryFQNMap() {
        HashMap allSurrogateQueries = Maps.newHashMap(this.registeredSurrogateQueryMap);
        allSurrogateQueries.putAll(this.dynamicSurrogateQueryMap);
        return allSurrogateQueries;
    }
}

