/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.incquery.runtime.matchers.context.surrogate.SurrogateQueryRegistry;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class SurrogateQueryRewriter
extends PDisjunctionRewriter {
    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet replacedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body){

                @Override
                protected void copyTypeBinaryConstraint(TypeBinary typeBinary) {
                    Object[] elements = typeBinary.getVariablesTuple().getElements();
                    PVariable source = (PVariable)elements[0];
                    PVariable target = (PVariable)elements[1];
                    Object typeKey = typeBinary.getSupplierKey();
                    if (SurrogateQueryRegistry.instance().hasSurrogateQueryFQN(typeKey)) {
                        PQuery surrogateQuery = SurrogateQueryRegistry.instance().getSurrogateQuery(typeKey);
                        if (surrogateQuery == null) {
                            throw new IllegalStateException(String.format("Surrogate query for feature %s not found", typeBinary.getTypeString()));
                        }
                        FlatTuple variablesTuple = new FlatTuple(this.variableMapping.get(source), this.variableMapping.get(target));
                        new PositivePatternCall(this.getCopiedBody(), (Tuple)variablesTuple, surrogateQuery);
                    } else {
                        new TypeBinary(this.getCopiedBody(), typeBinary.getContext(), (PVariable)this.variableMapping.get(source), (PVariable)this.variableMapping.get(target), typeKey, typeBinary.getTypeString());
                    }
                }
            };
            PBody modifiedBody = copier.getCopiedBody();
            replacedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(replacedBodies);
    }
}

