/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.patternregistry.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.incquery.runtime.patternregistry.PatternRegistryUtil;
import org.eclipse.incquery.runtime.patternregistry.PatternTypeEnum;

public class PatternInfo
implements IPatternInfo {
    private final PatternTypeEnum patternTypeEnum;
    private final Pattern pattern;
    private final IQuerySpecification<?> querySpecification;
    private final String id;
    private final String fqn;
    private final IFile relatedFile;
    private boolean active;
    private final List<Annotation> annotations;
    private final List<Variable> parameters;
    private final List<IPatternInfo> patternDependecies;

    public PatternInfo(PatternTypeEnum patternTypeEnum, Pattern pattern, IFile relatedFile, IQuerySpecification<?> querySpecification) {
        this.patternTypeEnum = patternTypeEnum;
        this.pattern = pattern;
        this.querySpecification = querySpecification;
        this.fqn = PatternRegistryUtil.getFQN(pattern);
        this.relatedFile = relatedFile;
        this.id = PatternRegistryUtil.getUniquePatternIdentifier(pattern);
        this.active = true;
        EList patternAnnotations = pattern.getAnnotations();
        this.annotations = Collections.unmodifiableList(patternAnnotations);
        EList patternParameters = pattern.getParameters();
        this.parameters = Collections.unmodifiableList(patternParameters);
        this.patternDependecies = Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public PatternTypeEnum getPatternTypeEnum() {
        return this.patternTypeEnum;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public IQuerySpecification<?> getQuerySpecification() {
        return this.querySpecification;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getFqn() {
        return this.fqn;
    }

    @Override
    public IFile getRelatedFile() {
        return this.relatedFile;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Variable> getParameters() {
        return this.parameters;
    }

    @Override
    public List<IPatternInfo> getPatternDependecies() {
        return this.patternDependecies;
    }
}

