/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.plancompiler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.helpers.BuildHelper;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.PEnumerate;
import org.eclipse.incquery.runtime.matchers.planning.operations.PJoin;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.planning.operations.PProject;
import org.eclipse.incquery.runtime.matchers.planning.operations.PStart;
import org.eclipse.incquery.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriterCacher;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.SurrogateQueryRewriter;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.construction.plancompiler.CompilerHelper;
import org.eclipse.incquery.runtime.rete.construction.plancompiler.RecursionCutoffPoint;
import org.eclipse.incquery.runtime.rete.recipes.AggregatorIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.AntiJoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.BinaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.CheckRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.incquery.runtime.rete.recipes.CountAggregatorRecipe;
import org.eclipse.incquery.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InequalityFilterRecipe;
import org.eclipse.incquery.runtime.rete.recipes.JoinRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.RecipesFactory;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TypeInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UnaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.incquery.runtime.rete.traceability.CompiledQuery;
import org.eclipse.incquery.runtime.rete.traceability.CompiledSubPlan;
import org.eclipse.incquery.runtime.rete.traceability.ParameterProjectionTrace;
import org.eclipse.incquery.runtime.rete.traceability.PlanningTrace;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

public class ReteRecipeCompiler {
    private IQueryPlannerStrategy plannerStrategy;
    private IPatternMatcherContext context;
    private IQueryBackendHintProvider hintProvider;
    private PDisjunctionRewriter normalizer;
    static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;
    private Map<PBody, SubPlan> plannerCache = new HashMap<PBody, SubPlan>();
    private Set<PBody> planningInProgress = new HashSet<PBody>();
    private Map<PQuery, CompiledQuery> queryCompilerCache = new HashMap<PQuery, CompiledQuery>();
    private Set<PQuery> compilationInProgress = new HashSet<PQuery>();
    private Multimap<PQuery, RecursionCutoffPoint> recursionCutoffPoints = HashMultimap.create();
    private Map<SubPlan, CompiledSubPlan> subPlanCompilerCache = new HashMap<SubPlan, CompiledSubPlan>();
    private Map<ReteNodeRecipe, SubPlan> compilerBackTrace = new HashMap<ReteNodeRecipe, SubPlan>();

    public ReteRecipeCompiler(IQueryPlannerStrategy plannerStrategy, IPatternMatcherContext context, IQueryBackendHintProvider hintProvider) {
        this.plannerStrategy = plannerStrategy;
        this.context = context;
        this.normalizer = new PDisjunctionRewriterCacher(new PDisjunctionRewriter[]{new SurrogateQueryRewriter(), new PBodyNormalizer(context)});
        this.hintProvider = hintProvider;
    }

    public void reset() {
        this.plannerCache.clear();
        this.planningInProgress.clear();
        this.queryCompilerCache.clear();
        this.subPlanCompilerCache.clear();
        this.compilerBackTrace.clear();
    }

    public CompiledQuery getCompiledForm(PQuery query) throws QueryProcessingException {
        CompiledQuery compiled = this.queryCompilerCache.get(query);
        if (compiled == null) {
            boolean reentrant;
            boolean bl = reentrant = !this.compilationInProgress.add(query);
            if (reentrant) {
                RecursionCutoffPoint cutoffPoint = new RecursionCutoffPoint(query);
                this.recursionCutoffPoints.put((Object)query, (Object)cutoffPoint);
                return cutoffPoint.getCompiledQuery();
            }
            try {
                compiled = this.compileProduction(query);
                this.queryCompilerCache.put(query, compiled);
                for (RecursionCutoffPoint cutoffPoint : this.recursionCutoffPoints.get((Object)query)) {
                    cutoffPoint.mend(compiled);
                }
            }
            finally {
                this.compilationInProgress.remove(query);
            }
        }
        return compiled;
    }

    public CompiledSubPlan getCompiledForm(SubPlan plan) throws QueryProcessingException {
        CompiledSubPlan compiled = this.subPlanCompilerCache.get(plan);
        if (compiled == null) {
            compiled = this.doCompileDispatch(plan);
            this.subPlanCompilerCache.put(plan, compiled);
            this.compilerBackTrace.put(compiled.getRecipe(), plan);
        }
        return compiled;
    }

    public SubPlan getPlan(PBody pBody) throws QueryProcessingException {
        SubPlan plan;
        PQuery pQuery = pBody.getPattern();
        if (!this.compilationInProgress.contains(pQuery)) {
            this.getCompiledForm(pQuery);
        }
        if ((plan = this.plannerCache.get(pBody)) == null) {
            boolean reentrant;
            boolean bl = reentrant = !this.planningInProgress.add(pBody);
            if (reentrant) {
                throw new IllegalArgumentException("Planning-level recursion unsupported: " + pBody.getPattern().getFullyQualifiedName());
            }
            try {
                plan = this.plannerStrategy.plan(pBody, this.context);
                this.plannerCache.put(pBody, plan);
            }
            finally {
                this.planningInProgress.remove(pBody);
            }
        }
        return plan;
    }

    private CompiledQuery compileProduction(PQuery query) throws QueryProcessingException {
        ArrayList<SubPlan> bodyPlans = new ArrayList<SubPlan>();
        for (PBody pBody : this.normalizer.rewrite(query).getBodies()) {
            SubPlan bodyPlan = this.getPlan(pBody);
            bodyPlans.add(bodyPlan);
        }
        return this.doCompileProduction(query, bodyPlans);
    }

    private CompiledQuery doCompileProduction(PQuery query, Collection<SubPlan> bodies) throws QueryProcessingException {
        HashSet<RecipeTraceInfo> bodyFinalTraces = new HashSet<RecipeTraceInfo>();
        HashSet<ReteNodeRecipe> bodyFinalRecipes = new HashSet<ReteNodeRecipe>();
        for (SubPlan bodyFinalPlan : bodies) {
            while (bodyFinalPlan.getOperation() instanceof PProject) {
                bodyFinalPlan = (SubPlan)bodyFinalPlan.getParentPlans().get(0);
            }
            CompiledSubPlan compiledBody = this.getCompiledForm(bodyFinalPlan);
            PBody body = bodyFinalPlan.getBody();
            List parameterList = body.getSymbolicParameterVariables();
            if (parameterList.equals(compiledBody.getVariablesTuple())) {
                bodyFinalTraces.add(compiledBody);
                bodyFinalRecipes.add(compiledBody.getRecipe());
                continue;
            }
            TrimmerRecipe trimmerRecipe = CompilerHelper.makeTrimmerRecipe(compiledBody, parameterList);
            ParameterProjectionTrace trimmerTrace = new ParameterProjectionTrace(body, (ReteNodeRecipe)trimmerRecipe, compiledBody);
            bodyFinalTraces.add(trimmerTrace);
            bodyFinalRecipes.add((ReteNodeRecipe)trimmerRecipe);
        }
        CompiledQuery compiled = CompilerHelper.makeQueryTrace(query, bodyFinalTraces, bodyFinalRecipes);
        return compiled;
    }

    private CompiledSubPlan doCompileDispatch(SubPlan plan) throws QueryProcessingException {
        POperation operation = plan.getOperation();
        if (operation instanceof PEnumerate) {
            return this.doCompileEnumerate(((PEnumerate)operation).getEnumerablePConstraint(), plan);
        }
        if (operation instanceof PApply) {
            PConstraint pConstraint = ((PApply)operation).getPConstraint();
            if (pConstraint instanceof EnumerablePConstraint) {
                CompiledSubPlan primaryParent = this.getCompiledForm((SubPlan)plan.getParentPlans().get(0));
                PlanningTrace secondaryParent = this.doEnumerateDispatch(plan, (EnumerablePConstraint)pConstraint);
                return this.compileToNaturalJoin(plan, primaryParent, secondaryParent);
            }
            if (pConstraint instanceof DeferredPConstraint) {
                return this.doDeferredDispatch((DeferredPConstraint)pConstraint, plan);
            }
            throw new IllegalArgumentException("Unsupported PConstraint in query plan: " + plan.toShortString());
        }
        if (operation instanceof PJoin) {
            return this.doCompileJoin((PJoin)operation, plan);
        }
        if (operation instanceof PProject) {
            return this.doCompileProject((PProject)operation, plan);
        }
        if (operation instanceof PStart) {
            return this.doCompileStart((PStart)operation, plan);
        }
        throw new IllegalArgumentException("Unsupported POperation in query plan: " + plan.toShortString());
    }

    private CompiledSubPlan doDeferredDispatch(DeferredPConstraint constraint, SubPlan plan) throws QueryProcessingException {
        SubPlan parentPlan = (SubPlan)plan.getParentPlans().get(0);
        CompiledSubPlan parentCompiled = this.getCompiledForm(parentPlan);
        if (constraint instanceof Equality) {
            return this.compileDeferred((Equality)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof ExportedParameter) {
            return this.compileDeferred((ExportedParameter)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof Inequality) {
            return this.compileDeferred((Inequality)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof NegativePatternCall) {
            return this.compileDeferred((NegativePatternCall)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof PatternMatchCounter) {
            return this.compileDeferred((PatternMatchCounter)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof ExpressionEvaluation) {
            return this.compileDeferred((ExpressionEvaluation)constraint, plan, parentPlan, parentCompiled);
        }
        throw new UnsupportedOperationException("Unknown deferred constraint " + constraint);
    }

    private CompiledSubPlan compileDeferred(Equality constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        if (constraint.isMoot()) {
            return parentCompiled.cloneFor(plan);
        }
        Integer index1 = parentCompiled.getPosMapping().get(constraint.getWho());
        Integer index2 = parentCompiled.getPosMapping().get(constraint.getWithWhom());
        if (index1 != null && index2 != null && index1 != index2) {
            Integer indexLower = Math.min(index1, index2);
            Integer indexHigher = Math.max(index1, index2);
            EqualityFilterRecipe equalityFilterRecipe = FACTORY.createEqualityFilterRecipe();
            equalityFilterRecipe.setParent(parentCompiled.getRecipe());
            equalityFilterRecipe.getIndices().add((Object)indexLower);
            equalityFilterRecipe.getIndices().add((Object)indexHigher);
            return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)equalityFilterRecipe, parentCompiled);
        }
        throw new IllegalArgumentException(String.format("Unable to interpret %s after compiled parent %s", plan.toShortString(), parentCompiled.toString()));
    }

    private CompiledSubPlan compileDeferred(ExportedParameter constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        return parentCompiled.cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(Inequality constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        if (constraint.isEliminable()) {
            return parentCompiled.cloneFor(plan);
        }
        Integer index1 = parentCompiled.getPosMapping().get(constraint.getWho());
        Integer index2 = parentCompiled.getPosMapping().get(constraint.getWithWhom());
        if (index1 != null && index2 != null && index1 != index2) {
            Integer indexLower = Math.min(index1, index2);
            Integer indexHigher = Math.max(index1, index2);
            InequalityFilterRecipe inequalityFilterRecipe = FACTORY.createInequalityFilterRecipe();
            inequalityFilterRecipe.setParent(parentCompiled.getRecipe());
            inequalityFilterRecipe.setSubject(indexLower);
            inequalityFilterRecipe.getInequals().add((Object)indexHigher);
            return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)inequalityFilterRecipe, parentCompiled);
        }
        throw new IllegalArgumentException(String.format("Unable to interpret %s after compiled parent %s", plan.toShortString(), parentCompiled.toString()));
    }

    private CompiledSubPlan compileDeferred(NegativePatternCall constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) throws QueryProcessingException {
        PlanningTrace callTrace = this.referQuery(constraint.getReferredQuery(), plan, constraint.getActualParametersTuple());
        CompilerHelper.JoinHelper joinHelper = new CompilerHelper.JoinHelper(plan, parentCompiled, callTrace);
        RecipeTraceInfo primaryIndexer = joinHelper.getPrimaryIndexer();
        RecipeTraceInfo secondaryIndexer = joinHelper.getSecondaryIndexer();
        AntiJoinRecipe antiJoinRecipe = FACTORY.createAntiJoinRecipe();
        antiJoinRecipe.setLeftParent((ProjectionIndexerRecipe)primaryIndexer.getRecipe());
        antiJoinRecipe.setRightParent((IndexerRecipe)secondaryIndexer.getRecipe());
        return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)antiJoinRecipe, primaryIndexer, secondaryIndexer);
    }

    private CompiledSubPlan compileDeferred(PatternMatchCounter constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) throws QueryProcessingException {
        PlanningTrace callTrace = this.referQuery(constraint.getReferredQuery(), plan, constraint.getActualParametersTuple());
        CompilerHelper.JoinHelper fakeJoinHelper = new CompilerHelper.JoinHelper(plan, parentCompiled, callTrace);
        RecipeTraceInfo primaryIndexer = fakeJoinHelper.getPrimaryIndexer();
        RecipeTraceInfo callProjectionIndexer = fakeJoinHelper.getSecondaryIndexer();
        List sideVariablesTuple = fakeJoinHelper.getSecondaryMask().transform(callTrace.getVariablesTuple());
        sideVariablesTuple.add(constraint.getResultVariable());
        CountAggregatorRecipe aggregatorRecipe = FACTORY.createCountAggregatorRecipe();
        aggregatorRecipe.setParent((ProjectionIndexerRecipe)callProjectionIndexer.getRecipe());
        PlanningTrace aggregatorTrace = new PlanningTrace(plan, (List<PVariable>)sideVariablesTuple, (ReteNodeRecipe)aggregatorRecipe, callProjectionIndexer);
        AggregatorIndexerRecipe aggregatorIndexerRecipe = FACTORY.createAggregatorIndexerRecipe();
        aggregatorIndexerRecipe.setParent((ReteNodeRecipe)aggregatorRecipe);
        aggregatorIndexerRecipe.setMask(RecipesHelper.mask((int)sideVariablesTuple.size(), (int[])fakeJoinHelper.getSecondaryMask().indices));
        PlanningTrace aggregatorIndexerTrace = new PlanningTrace(plan, (List<PVariable>)sideVariablesTuple, (ReteNodeRecipe)aggregatorIndexerRecipe, aggregatorTrace);
        JoinRecipe naturalJoinRecipe = FACTORY.createJoinRecipe();
        naturalJoinRecipe.setLeftParent((ProjectionIndexerRecipe)primaryIndexer.getRecipe());
        naturalJoinRecipe.setRightParent((IndexerRecipe)aggregatorIndexerRecipe);
        naturalJoinRecipe.setRightParentComplementaryMask(RecipesHelper.mask((int)sideVariablesTuple.size(), (int[])new int[]{sideVariablesTuple.size() - 1}));
        boolean alreadyKnown = parentPlan.getVisibleVariables().contains(constraint.getResultVariable());
        ArrayList<PVariable> aggregatedVariablesTuple = new ArrayList<PVariable>(parentCompiled.getVariablesTuple());
        if (!alreadyKnown) {
            aggregatedVariablesTuple.add(constraint.getResultVariable());
        }
        PlanningTrace joinTrace = new PlanningTrace(plan, aggregatedVariablesTuple, (ReteNodeRecipe)naturalJoinRecipe, primaryIndexer, aggregatorIndexerTrace);
        return CompilerHelper.checkAndTrimEqualVariables(plan, joinTrace).cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(ExpressionEvaluation constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        HashMap<String, Integer> tupleNameMap = new HashMap<String, Integer>();
        for (String name : constraint.getEvaluator().getInputParameterNames()) {
            Map<PVariable, Integer> index = parentCompiled.getPosMapping();
            PVariable pVariable = constraint.getPSystem().getVariableByNameChecked((Object)name);
            Integer position = index.get(pVariable);
            tupleNameMap.put(name, position);
        }
        PVariable outputVariable = constraint.getOutputVariable();
        boolean booleanCheck = outputVariable == null;
        CheckRecipe enforcerRecipe = booleanCheck ? FACTORY.createCheckRecipe() : FACTORY.createEvalRecipe();
        enforcerRecipe.setParent(parentCompiled.getRecipe());
        enforcerRecipe.setExpression(RecipesHelper.expressionDefinition((Object)constraint.getEvaluator()));
        for (Map.Entry entry : tupleNameMap.entrySet()) {
            enforcerRecipe.getMappedIndices().put((Object)((String)entry.getKey()), (Object)((Integer)entry.getValue()));
        }
        ArrayList<PVariable> arrayList = new ArrayList<PVariable>(parentCompiled.getVariablesTuple());
        if (!booleanCheck) {
            arrayList.add(outputVariable);
        }
        PlanningTrace enforcerTrace = new PlanningTrace(plan, arrayList, (ReteNodeRecipe)enforcerRecipe, parentCompiled);
        return CompilerHelper.checkAndTrimEqualVariables(plan, enforcerTrace).cloneFor(plan);
    }

    private CompiledSubPlan doCompileJoin(PJoin operation, SubPlan plan) throws QueryProcessingException {
        List<CompiledSubPlan> compiledParents = this.getCompiledFormOfParents(plan);
        CompiledSubPlan leftCompiled = compiledParents.get(0);
        CompiledSubPlan rightCompiled = compiledParents.get(1);
        return this.compileToNaturalJoin(plan, leftCompiled, rightCompiled);
    }

    private CompiledSubPlan compileToNaturalJoin(SubPlan plan, PlanningTrace leftCompiled, PlanningTrace rightCompiled) {
        CompilerHelper.JoinHelper joinHelper = new CompilerHelper.JoinHelper(plan, leftCompiled, rightCompiled);
        return new CompiledSubPlan(plan, joinHelper.getNaturalJoinVariablesTuple(), (ReteNodeRecipe)joinHelper.getNaturalJoinRecipe(), joinHelper.getPrimaryIndexer(), joinHelper.getSecondaryIndexer());
    }

    private CompiledSubPlan doCompileProject(PProject operation, SubPlan plan) throws QueryProcessingException {
        List<CompiledSubPlan> compiledParents = this.getCompiledFormOfParents(plan);
        CompiledSubPlan compiledParent = compiledParents.get(0);
        ArrayList<PVariable> projectedVariables = new ArrayList<PVariable>(operation.getToVariables());
        TrimmerRecipe trimmerRecipe = CompilerHelper.makeTrimmerRecipe(compiledParent, projectedVariables);
        if (BuildHelper.areAllVariablesDetermined((SubPlan)((SubPlan)plan.getParentPlans().get(0)), projectedVariables)) {
            return new CompiledSubPlan(plan, projectedVariables, (ReteNodeRecipe)trimmerRecipe, compiledParent);
        }
        PlanningTrace trimTrace = new PlanningTrace(plan, projectedVariables, (ReteNodeRecipe)trimmerRecipe, compiledParent);
        UniquenessEnforcerRecipe uniquenessEnforcerRecipe = FACTORY.createUniquenessEnforcerRecipe();
        uniquenessEnforcerRecipe.getParents().add((Object)trimmerRecipe);
        return new CompiledSubPlan(plan, projectedVariables, (ReteNodeRecipe)uniquenessEnforcerRecipe, trimTrace);
    }

    private CompiledSubPlan doCompileStart(PStart operation, SubPlan plan) {
        if (!operation.getAPrioriVariables().isEmpty()) {
            throw new IllegalArgumentException("Input variables unsupported by Rete: " + plan.toShortString());
        }
        ConstantRecipe recipe = FACTORY.createConstantRecipe();
        recipe.getConstantValues().clear();
        return new CompiledSubPlan(plan, new ArrayList<PVariable>(), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private CompiledSubPlan doCompileEnumerate(EnumerablePConstraint constraint, SubPlan plan) throws QueryProcessingException {
        PlanningTrace trimmedTrace = this.doEnumerateAndDeduplicate(constraint, plan);
        return trimmedTrace.cloneFor(plan);
    }

    private PlanningTrace doEnumerateAndDeduplicate(EnumerablePConstraint constraint, SubPlan plan) throws QueryProcessingException {
        PlanningTrace coreTrace = this.doEnumerateDispatch(plan, constraint);
        PlanningTrace trimmedTrace = CompilerHelper.checkAndTrimEqualVariables(plan, coreTrace);
        return trimmedTrace;
    }

    private PlanningTrace doEnumerateDispatch(SubPlan plan, EnumerablePConstraint constraint) throws QueryProcessingException {
        if (constraint instanceof BinaryTransitiveClosure) {
            return this.compileEnumerable(plan, (BinaryTransitiveClosure)constraint);
        }
        if (constraint instanceof ConstantValue) {
            return this.compileEnumerable(plan, (ConstantValue)constraint);
        }
        if (constraint instanceof PositivePatternCall) {
            return this.compileEnumerable(plan, (PositivePatternCall)constraint);
        }
        if (constraint instanceof TypeBinary) {
            return this.compileEnumerable(plan, (TypeBinary)constraint);
        }
        if (constraint instanceof TypeUnary) {
            return this.compileEnumerable(plan, (TypeUnary)constraint);
        }
        throw new UnsupportedOperationException("Unknown enumerable constraint " + constraint);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, BinaryTransitiveClosure constraint) throws QueryProcessingException {
        PQuery referredQuery = (PQuery)constraint.getSupplierKey();
        PlanningTrace callTrace = this.referQuery(referredQuery, plan, constraint.getVariablesTuple());
        TransitiveClosureRecipe recipe = FACTORY.createTransitiveClosureRecipe();
        recipe.setParent(callTrace.getRecipe());
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, callTrace);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, PositivePatternCall constraint) throws QueryProcessingException {
        PQuery referredQuery = constraint.getReferredQuery();
        return this.referQuery(referredQuery, plan, constraint.getVariablesTuple());
    }

    private PlanningTrace compileEnumerable(SubPlan plan, TypeBinary constraint) {
        BinaryInputRecipe recipe = FACTORY.createBinaryInputRecipe();
        this.initTypeInputRecipe((TypeConstraint)constraint, (TypeInputRecipe)recipe);
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, TypeUnary constraint) {
        UnaryInputRecipe recipe = FACTORY.createUnaryInputRecipe();
        this.initTypeInputRecipe((TypeConstraint)constraint, (TypeInputRecipe)recipe);
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private void initTypeInputRecipe(TypeConstraint constraint, TypeInputRecipe recipe) {
        recipe.setTypeKey(constraint.getSupplierKey());
        recipe.setTypeName(constraint.getTypeString());
    }

    private PlanningTrace compileEnumerable(SubPlan plan, ConstantValue constraint) {
        ConstantRecipe recipe = FACTORY.createConstantRecipe();
        recipe.getConstantValues().add(constraint.getSupplierKey());
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private PlanningTrace referQuery(PQuery query, SubPlan plan, Tuple actualParametersTuple) throws QueryProcessingException {
        CompiledQuery compiledQuery = this.getCompiledForm(query);
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple(actualParametersTuple), compiledQuery.getRecipe(), compiledQuery.getParentRecipeTraces());
    }

    protected List<CompiledSubPlan> getCompiledFormOfParents(SubPlan plan) throws QueryProcessingException {
        ArrayList<CompiledSubPlan> results = new ArrayList<CompiledSubPlan>();
        for (SubPlan parentPlan : plan.getParentPlans()) {
            results.add(this.getCompiledForm(parentPlan));
        }
        return results;
    }

    public Map<PQuery, CompiledQuery> getCachedCompiledQueries() {
        return Collections.unmodifiableMap(this.queryCompilerCache);
    }

    public Map<PBody, SubPlan> getCachedQueryPlans() {
        return Collections.unmodifiableMap(this.plannerCache);
    }
}

