/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class IncQueryRuntimeHelper {
    public static EStructuralFeature getFeature(Object o, String featureName) {
        if (o instanceof EObject) {
            EStructuralFeature feature = ((EObject)o).eClass().getEStructuralFeature(featureName);
            return feature;
        }
        return null;
    }

    public static String getMessage(IPatternMatch match, String messageFormat) {
        String[] tokens = messageFormat.split("\\$");
        StringBuilder newText = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (i % 2 == 0) {
                newText.append(tokens[i]);
            } else {
                String[] objectTokens = tokens[i].split("\\.");
                if (objectTokens.length > 0) {
                    Object o = null;
                    EStructuralFeature feature = null;
                    if (objectTokens.length == 1) {
                        o = match.get(objectTokens[0]);
                        feature = IncQueryRuntimeHelper.getFeature(o, "name");
                    }
                    if (objectTokens.length == 2) {
                        o = match.get(objectTokens[0]);
                        feature = IncQueryRuntimeHelper.getFeature(o, objectTokens[1]);
                    }
                    if (o != null && feature != null) {
                        Object value = ((EObject)o).eGet(feature);
                        if (value != null) {
                            newText.append(value.toString());
                        } else {
                            newText.append("null");
                        }
                    } else if (o != null) {
                        newText.append(o.toString());
                    }
                } else {
                    newText.append("[no such parameter]");
                }
            }
            ++i;
        }
        return newText.toString();
    }
}

