/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.extensibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQueryGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public final class QuerySpecificationRegistry {
    private static final Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> QUERY_SPECIFICATIONS = QuerySpecificationRegistry.createQuerySpecificationRegistry();

    private QuerySpecificationRegistry() {
    }

    private static Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> createQuerySpecificationRegistry() {
        HashMap<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications = new HashMap<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>();
        QuerySpecificationRegistry.initRegistry(specifications);
        return specifications;
    }

    private static void initRegistry(Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications) {
        specifications.clear();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg == null) {
            return;
        }
        IExtensionPoint poi = reg.getExtensionPoint("org.eclipse.incquery.runtime.queryspecification");
        if (poi != null) {
            IExtension[] exts = poi.getExtensions();
            HashSet<String> duplicates = new HashSet<String>();
            IExtension[] iExtensionArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] els;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = els = ext.getConfigurationElements();
                int n3 = els.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("group")) {
                        QuerySpecificationRegistry.prepareQueryGroup(specifications, duplicates, el);
                    } else {
                        IncQueryLoggingUtil.getLogger(QuerySpecificationRegistry.class).error((Object)("[QuerySpecificationRegistry] Unknown configuration element " + el.getName() + " in plugin.xml of " + el.getDeclaringExtension().getUniqueIdentifier()));
                    }
                    ++n4;
                }
                ++n2;
            }
            if (!duplicates.isEmpty()) {
                StringBuilder duplicateSB = new StringBuilder("[QuerySpecificationRegistry] Trying to register patterns with the same FQN multiple times. Check your plug-in configuration!\n");
                duplicateSB.append("The following pattern FQNs appeared multiple times:\n");
                for (String fqn : duplicates) {
                    duplicateSB.append(String.format("\t%s%n", fqn));
                }
                IncQueryLoggingUtil.getLogger(QuerySpecificationRegistry.class).warn((Object)duplicateSB.toString());
            }
        }
    }

    private static void prepareQueryGroup(Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications, Set<String> duplicates, IConfigurationElement el) {
        String id = null;
        try {
            id = el.getAttribute("id");
            IQueryGroup group = (IQueryGroup)el.createExecutableExtension("group");
            for (IQuerySpecification<?> specification : group.getSpecifications()) {
                QuerySpecificationRegistry.loadQuerySpecification(specifications, duplicates, el, specification);
            }
        }
        catch (Throwable e) {
            if (id == null) {
                id = "undefined in plugin.xml";
            }
            IncQueryLoggingUtil.getLogger(QuerySpecificationRegistry.class).error((Object)("[QuerySpecificationRegistry] Exception during query specification registry initialization when preparing group: " + id + "! " + e.getMessage()), e);
        }
    }

    private static void loadQuerySpecification(Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications, Set<String> duplicates, IConfigurationElement el, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification) {
        String fullyQualifiedName = querySpecification.getFullyQualifiedName();
        if (specifications.containsKey(fullyQualifiedName)) {
            duplicates.add(fullyQualifiedName);
        } else {
            specifications.put(fullyQualifiedName, querySpecification);
        }
    }

    public static void registerQuerySpecification(IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> specification) {
        String qualifiedName = specification.getFullyQualifiedName();
        if (!QUERY_SPECIFICATIONS.containsKey(qualifiedName)) {
            QUERY_SPECIFICATIONS.put(qualifiedName, specification);
        } else {
            IncQueryLoggingUtil.getLogger(QuerySpecificationRegistry.class).warn((Object)String.format("[QuerySpecificationRegistry] Trying to register duplicate FQN (%s). Check your plug-in configuration!", qualifiedName));
        }
    }

    public static void unregisterQuerySpecification(String patternFQN) {
        QUERY_SPECIFICATIONS.remove(patternFQN);
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getContributedQuerySpecifications() {
        return new HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>(QUERY_SPECIFICATIONS.values());
    }

    public static IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> getQuerySpecification(String patternFQN) {
        if (QUERY_SPECIFICATIONS.containsKey(patternFQN)) {
            return QUERY_SPECIFICATIONS.get(patternFQN);
        }
        return null;
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternGroup(String packageFQN) {
        return QuerySpecificationRegistry.getPatternGroupOrSubTree(packageFQN, false);
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternSubTree(String packageFQN) {
        return QuerySpecificationRegistry.getPatternGroupOrSubTree(packageFQN, true);
    }

    private static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternGroupOrSubTree(String packageFQN, boolean includeSubPackages) {
        HashMap<String, HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>> map = new HashMap<String, HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>>();
        if (map.containsKey(packageFQN)) {
            return (Set)map.get(packageFQN);
        }
        HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> group = new HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>();
        for (Map.Entry<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> entry : QUERY_SPECIFICATIONS.entrySet()) {
            QuerySpecificationRegistry.addPatternToGroup(packageFQN, group, entry.getKey(), entry.getValue(), includeSubPackages);
        }
        if (group.size() > 0) {
            map.put(packageFQN, group);
        }
        return group;
    }

    private static void addPatternToGroup(String packageFQN, Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> group, String patternFQN, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> specification, boolean includeSubPackages) {
        if (packageFQN.length() + 1 < patternFQN.length()) {
            if (includeSubPackages) {
                if (patternFQN.startsWith(String.valueOf(packageFQN) + '.')) {
                    group.add(specification);
                }
            } else {
                String name = patternFQN.substring(patternFQN.lastIndexOf(46) + 1, patternFQN.length());
                if (patternFQN.equals(String.valueOf(packageFQN) + '.' + name)) {
                    group.add(specification);
                }
            }
        }
    }
}

