/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.handlers;

import org.apache.log4j.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class IncQueryProjectVersionTester
extends PropertyTester {
    private static final String VERSION_TESTER = "current";

    private boolean hasIncorrectBuildCommandOrdering(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int xtextIndex = -1;
        int iqIndex = -1;
        int jdtIndex = -1;
        int i = 0;
        while (i < commands.length) {
            String id = commands[i].getBuilderName();
            if ("org.eclipse.incquery.tooling.core.projectbuilder".equals(id)) {
                iqIndex = i;
            } else if ("org.eclipse.xtext.ui.shared.xtextBuilder".equals(id)) {
                xtextIndex = i;
            } else if ("org.eclipse.jdt.core.javabuilder".equals(id)) {
                jdtIndex = i;
            }
            ++i;
        }
        return jdtIndex < xtextIndex || jdtIndex < iqIndex;
    }

    private boolean hasLog4jDependency(IProject project) throws JavaModelException {
        return JavaCore.create((IProject)project).findType(Logger.class.getName()) == null;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block4: {
            IProject project;
            block5: {
                try {
                    if (!VERSION_TESTER.equals(property) || !(receiver instanceof IProject) || !((IProject)receiver).isAccessible()) break block4;
                    project = (IProject)receiver;
                    if (!project.hasNature("org.eclipse.viatra2.emf.incquery.projectnature")) break block5;
                    return true;
                }
                catch (Exception exception) {}
            }
            if (project.hasNature("org.eclipse.incquery.projectnature")) {
                return project.findMember("queries/globalEiqModel.xmi") != null || this.hasIncorrectBuildCommandOrdering(project) || this.hasLog4jDependency(project);
            }
        }
        return false;
    }
}

