package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.uml.derivedfeatures.OperationReturnResultMatch;
import org.eclipse.incquery.uml.derivedfeatures.OperationReturnResultMatcher;

/**
 * A pattern-specific query specification that can instantiate OperationReturnResultMatcher in a type-safe way.
 * 
 * @see OperationReturnResultMatcher
 * @see OperationReturnResultMatch
 * 
 */
@SuppressWarnings("all")
public final class OperationReturnResultQuerySpecification extends BaseGeneratedEMFQuerySpecification<OperationReturnResultMatcher> {
  private OperationReturnResultQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static OperationReturnResultQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected OperationReturnResultMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return OperationReturnResultMatcher.on(engine);
  }
  
  @Override
  public OperationReturnResultMatch newEmptyMatch() {
    return OperationReturnResultMatch.newEmptyMatch();
  }
  
  @Override
  public OperationReturnResultMatch newMatch(final Object... parameters) {
    return OperationReturnResultMatch.newMatch((org.eclipse.uml2.uml.Operation) parameters[0], (org.eclipse.uml2.uml.Parameter) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static OperationReturnResultQuerySpecification INSTANCE = make();
    
    public static OperationReturnResultQuerySpecification make() {
      return new OperationReturnResultQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static OperationReturnResultQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.operationReturnResult";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp1");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Operation"),new PParameter("temp1", "org.eclipse.uml2.uml.Parameter"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var_parameterDirectionKind = body.getOrCreateVariableByName("parameterDirectionKind");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_parameterDirectionKind_0 = body.getOrCreateVariableByName("parameterDirectionKind_0");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	PVariable var_parameter = body.getOrCreateVariableByName("parameter");
      	PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_temp1, "temp1")
      	));
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Operation"), "http://www.eclipse.org/uml2/5.0.0/UML/Operation");
      	new TypeUnary(body, var_temp1, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Parameter"), "http://www.eclipse.org/uml2/5.0.0/UML/Parameter");
      	new TypeUnary(body, var_temp1, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Parameter"), "http://www.eclipse.org/uml2/5.0.0/UML/Parameter");
      	new TypeBinary(body, CONTEXT, var_temp1, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Parameter", "direction"), "http://www.eclipse.org/uml2/5.0.0/UML/Parameter.direction");
      	new Equality(body, var__virtual_0_, var_parameterDirectionKind);
      	new ConstantValue(body, var__virtual_1_, org.eclipse.uml2.uml.ParameterDirectionKind.get("return"));
      	new Equality(body, var_parameterDirectionKind_0, var__virtual_1_);
      	new Equality(body, var_parameterDirectionKind, var_parameterDirectionKind_0);
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "BehavioralFeature"), "http://www.eclipse.org/uml2/5.0.0/UML/BehavioralFeature");
      	new TypeBinary(body, CONTEXT, var_self, var__virtual_2_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "BehavioralFeature", "ownedParameter"), "http://www.eclipse.org/uml2/5.0.0/UML/BehavioralFeature.ownedParameter");
      	new Equality(body, var__virtual_2_, var_parameter);
      	new Equality(body, var_temp1, var_parameter);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
