package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;

/**
 * A pattern-specific query specification that can instantiate PackageImportedPackageMatcher in a type-safe way.
 * 
 * @see PackageImportedPackageMatcher
 * @see PackageImportedPackageMatch
 * 
 */
@SuppressWarnings("all")
final class PackageImportedPackageQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private PackageImportedPackageQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageImportedPackageQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static PackageImportedPackageQuerySpecification INSTANCE = make();
    
    public static PackageImportedPackageQuerySpecification make() {
      return new PackageImportedPackageQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageImportedPackageQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageImportedPackage";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("package_","importedPackage");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("package_", "org.eclipse.uml2.uml.Package"),new PParameter("importedPackage", "org.eclipse.uml2.uml.Package"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_package_ = body.getOrCreateVariableByName("package_");
      	PVariable var_importedPackage = body.getOrCreateVariableByName("importedPackage");
      	PVariable var_packageImport = body.getOrCreateVariableByName("packageImport");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      	PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_package_, "package_"),
      				
      		new ExportedParameter(body, var_importedPackage, "importedPackage")
      	));
      	new TypeUnary(body, var_package_, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package"), "http://www.eclipse.org/uml2/5.0.0/UML/Package");
      	new TypeUnary(body, var_importedPackage, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package"), "http://www.eclipse.org/uml2/5.0.0/UML/Package");
      	new TypeUnary(body, var_package_, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace"), "http://www.eclipse.org/uml2/5.0.0/UML/Namespace");
      	new TypeBinary(body, CONTEXT, var_package_, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace", "packageImport"), "http://www.eclipse.org/uml2/5.0.0/UML/Namespace.packageImport");
      	new Equality(body, var__virtual_0_, var_packageImport);
      	new ConstantValue(body, var__virtual_1_, org.eclipse.uml2.uml.VisibilityKind.get("public"));
      	new TypeUnary(body, var_packageImport, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport"), "http://www.eclipse.org/uml2/5.0.0/UML/PackageImport");
      	new TypeBinary(body, CONTEXT, var_packageImport, var__virtual_2_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport", "visibility"), "http://www.eclipse.org/uml2/5.0.0/UML/PackageImport.visibility");
      	new Equality(body, var__virtual_2_, var__virtual_1_);
      	new TypeUnary(body, var_packageImport, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport"), "http://www.eclipse.org/uml2/5.0.0/UML/PackageImport");
      	new TypeBinary(body, CONTEXT, var_packageImport, var__virtual_3_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageImport", "importedPackage"), "http://www.eclipse.org/uml2/5.0.0/UML/PackageImport.importedPackage");
      	new Equality(body, var__virtual_3_, var_importedPackage);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
