package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.uml.derivedfeatures.AssociationEndTypeMatch;
import org.eclipse.incquery.uml.derivedfeatures.AssociationEndTypeMatcher;

/**
 * A pattern-specific query specification that can instantiate AssociationEndTypeMatcher in a type-safe way.
 * 
 * @see AssociationEndTypeMatcher
 * @see AssociationEndTypeMatch
 * 
 */
@SuppressWarnings("all")
public final class AssociationEndTypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<AssociationEndTypeMatcher> {
  private AssociationEndTypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static AssociationEndTypeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected AssociationEndTypeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return AssociationEndTypeMatcher.on(engine);
  }
  
  @Override
  public AssociationEndTypeMatch newEmptyMatch() {
    return AssociationEndTypeMatch.newEmptyMatch();
  }
  
  @Override
  public AssociationEndTypeMatch newMatch(final Object... parameters) {
    return AssociationEndTypeMatch.newMatch((org.eclipse.uml2.uml.Association) parameters[0], (org.eclipse.uml2.uml.Type) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static AssociationEndTypeQuerySpecification INSTANCE = make();
    
    public static AssociationEndTypeQuerySpecification make() {
      return new AssociationEndTypeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static AssociationEndTypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.associationEndType";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","type");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Association"),new PParameter("type", "org.eclipse.uml2.uml.Type"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_type = body.getOrCreateVariableByName("type");
      	PVariable var_property = body.getOrCreateVariableByName("property");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_type, "type")
      	));
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Association"), "http://www.eclipse.org/uml2/5.0.0/UML/Association");
      	new TypeUnary(body, var_type, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Type"), "http://www.eclipse.org/uml2/5.0.0/UML/Type");
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Association"), "http://www.eclipse.org/uml2/5.0.0/UML/Association");
      	new TypeBinary(body, CONTEXT, var_self, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Association", "memberEnd"), "http://www.eclipse.org/uml2/5.0.0/UML/Association.memberEnd");
      	new Equality(body, var__virtual_0_, var_property);
      	new Equality(body, var_temp1, var_property);
      	new TypeUnary(body, var_temp1, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "TypedElement"), "http://www.eclipse.org/uml2/5.0.0/UML/TypedElement");
      	new TypeBinary(body, CONTEXT, var_temp1, var__virtual_1_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "TypedElement", "type"), "http://www.eclipse.org/uml2/5.0.0/UML/TypedElement.type");
      	new Equality(body, var__virtual_1_, var_type);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "endType");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
