package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;

/**
 * A pattern-specific query specification that can instantiate ConnectorEndPartWithPortMatcher in a type-safe way.
 * 
 * @see ConnectorEndPartWithPortMatcher
 * @see ConnectorEndPartWithPortMatch
 * 
 */
@SuppressWarnings("all")
final class ConnectorEndPartWithPortQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private ConnectorEndPartWithPortQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ConnectorEndPartWithPortQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static ConnectorEndPartWithPortQuerySpecification INSTANCE = make();
    
    public static ConnectorEndPartWithPortQuerySpecification make() {
      return new ConnectorEndPartWithPortQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ConnectorEndPartWithPortQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.connectorEndPartWithPort";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("connectorEnd","partWithPort");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("connectorEnd", "org.eclipse.uml2.uml.ConnectorEnd"),new PParameter("partWithPort", "org.eclipse.uml2.uml.Property"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_connectorEnd = body.getOrCreateVariableByName("connectorEnd");
      	PVariable var_partWithPort = body.getOrCreateVariableByName("partWithPort");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_connectorEnd, "connectorEnd"),
      				
      		new ExportedParameter(body, var_partWithPort, "partWithPort")
      	));
      	new TypeUnary(body, var_connectorEnd, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd"), "http://www.eclipse.org/uml2/5.0.0/UML/ConnectorEnd");
      	new TypeUnary(body, var_partWithPort, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Property"), "http://www.eclipse.org/uml2/5.0.0/UML/Property");
      	new TypeUnary(body, var_connectorEnd, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd"), "http://www.eclipse.org/uml2/5.0.0/UML/ConnectorEnd");
      	new TypeBinary(body, CONTEXT, var_connectorEnd, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd", "partWithPort"), "http://www.eclipse.org/uml2/5.0.0/UML/ConnectorEnd.partWithPort");
      	new Equality(body, var__virtual_0_, var_partWithPort);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
