package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;

/**
 * A pattern-specific query specification that can instantiate MessageReceiveEventMatcher in a type-safe way.
 * 
 * @see MessageReceiveEventMatcher
 * @see MessageReceiveEventMatch
 * 
 */
@SuppressWarnings("all")
final class MessageReceiveEventQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private MessageReceiveEventQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static MessageReceiveEventQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static MessageReceiveEventQuerySpecification INSTANCE = make();
    
    public static MessageReceiveEventQuerySpecification make() {
      return new MessageReceiveEventQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static MessageReceiveEventQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.messageReceiveEvent";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","receiveEvent");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Message"),new PParameter("receiveEvent", "org.eclipse.uml2.uml.MessageEnd"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_receiveEvent = body.getOrCreateVariableByName("receiveEvent");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_receiveEvent, "receiveEvent")
      	));
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message"), "http://www.eclipse.org/uml2/5.0.0/UML/Message");
      	new TypeUnary(body, var_receiveEvent, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "MessageEnd"), "http://www.eclipse.org/uml2/5.0.0/UML/MessageEnd");
      	new TypeUnary(body, var_self, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message"), "http://www.eclipse.org/uml2/5.0.0/UML/Message");
      	new TypeBinary(body, CONTEXT, var_self, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Message", "receiveEvent"), "http://www.eclipse.org/uml2/5.0.0/UML/Message.receiveEvent");
      	new Equality(body, var__virtual_0_, var_receiveEvent);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
