package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.MessageMessageKindMatch;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.messageMessageKind pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class MessageMessageKindProcessor implements IMatchProcessor<MessageMessageKindMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pMessageKind the value of pattern parameter messageKind in the currently processed match
   * 
   */
  public abstract void process(final Message pSelf, final MessageKind pMessageKind);
  
  @Override
  public void process(final MessageMessageKindMatch match) {
    process(match.getSelf(), match.getMessageKind());
  }
}
