package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.uml.derivedfeatures.OpaqueExpressionResultMatch;
import org.eclipse.incquery.uml.derivedfeatures.OpaqueExpressionResultMatcher;

/**
 * A pattern-specific query specification that can instantiate OpaqueExpressionResultMatcher in a type-safe way.
 * 
 * @see OpaqueExpressionResultMatcher
 * @see OpaqueExpressionResultMatch
 * 
 */
@SuppressWarnings("all")
public final class OpaqueExpressionResultQuerySpecification extends BaseGeneratedEMFQuerySpecification<OpaqueExpressionResultMatcher> {
  private OpaqueExpressionResultQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static OpaqueExpressionResultQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected OpaqueExpressionResultMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return OpaqueExpressionResultMatcher.on(engine);
  }
  
  @Override
  public OpaqueExpressionResultMatch newEmptyMatch() {
    return OpaqueExpressionResultMatch.newEmptyMatch();
  }
  
  @Override
  public OpaqueExpressionResultMatch newMatch(final Object... parameters) {
    return OpaqueExpressionResultMatch.newMatch((org.eclipse.uml2.uml.OpaqueExpression) parameters[0], (org.eclipse.uml2.uml.Parameter) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static OpaqueExpressionResultQuerySpecification INSTANCE = make();
    
    public static OpaqueExpressionResultQuerySpecification make() {
      return new OpaqueExpressionResultQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static OpaqueExpressionResultQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.opaqueExpressionResult";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "org.eclipse.uml2.uml.OpaqueExpression"),new PParameter("target", "org.eclipse.uml2.uml.Parameter"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_source = body.getOrCreateVariableByName("source");
      	PVariable var_target = body.getOrCreateVariableByName("target");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_source, "source"),
      				
      		new ExportedParameter(body, var_target, "target")
      	));
      	new TypeUnary(body, var_source, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "OpaqueExpression"), "http://www.eclipse.org/uml2/5.0.0/UML/OpaqueExpression");
      	new TypeUnary(body, var_target, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Parameter"), "http://www.eclipse.org/uml2/5.0.0/UML/Parameter");
      	new TypeUnary(body, var_source, getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "OpaqueExpression"), "http://www.eclipse.org/uml2/5.0.0/UML/OpaqueExpression");
      	new TypeBinary(body, CONTEXT, var_source, var__virtual_0_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "OpaqueExpression", "behavior"), "http://www.eclipse.org/uml2/5.0.0/UML/OpaqueExpression.behavior");
      	new TypeBinary(body, CONTEXT, var__virtual_0_, var__virtual_1_, getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Behavior", "ownedParameter"), "http://www.eclipse.org/uml2/5.0.0/UML/Behavior.ownedParameter");
      	new Equality(body, var__virtual_1_, var_target);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "result");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
